/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.asm;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.simpleflatmapper.reflect.BiInstantiator;
import org.simpleflatmapper.reflect.BuilderInstantiatorDefinition;
import org.simpleflatmapper.reflect.FactoryClassLoader;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.Instantiator;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.asm.BiInstantiatorBuilder;
import org.simpleflatmapper.reflect.asm.BiInstantiatorKey;
import org.simpleflatmapper.reflect.asm.ConstructorBuilder;
import org.simpleflatmapper.reflect.asm.GetterBuilder;
import org.simpleflatmapper.reflect.asm.InstantiatorBuilder;
import org.simpleflatmapper.reflect.asm.InstantiatorKey;
import org.simpleflatmapper.reflect.asm.SetterBuilder;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;
import org.simpleflatmapper.util.BiFunction;
import org.simpleflatmapper.util.TypeHelper;
import org.simpleflatmapper.util.UnaryFactory;

public class AsmFactory {
    private final FactoryClassLoader factoryClassLoader;
    private final ConcurrentMap<Object, Setter<?, ?>> setterCache = new ConcurrentHashMap();
    private final ConcurrentMap<Object, Getter<?, ?>> getterCache = new ConcurrentHashMap();
    private final ConcurrentMap<InstantiatorKey, Class<? extends Instantiator<?, ?>>> instantiatorCache = new ConcurrentHashMap();
    private final ConcurrentMap<BiInstantiatorKey, Class<? extends BiInstantiator<?, ?, ?>>> biInstantiatorCache = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, Object> subFactories = new ConcurrentHashMap();
    private final AtomicLong classNumber = new AtomicLong();

    public AsmFactory(ClassLoader cl) {
        this.factoryClassLoader = new FactoryClassLoader(cl);
    }

    public <T, P> Setter<T, P> createSetter(Method m) throws Exception {
        Setter setter = (Setter)this.setterCache.get(m);
        if (setter == null) {
            String className = this.generateClassNameForSetter(m);
            byte[] bytes = this.generateSetterByteCodes(m, className);
            Class<?> type = this.createClass(className, bytes, m.getDeclaringClass().getClassLoader());
            setter = (Setter)type.newInstance();
            this.setterCache.putIfAbsent(m, setter);
        }
        return setter;
    }

    public <T, P> Setter<T, P> createSetter(Field field) throws Exception {
        Setter setter = (Setter)this.setterCache.get(field);
        if (setter == null) {
            String className = this.generateClassNameForSetter(field);
            byte[] bytes = this.generateSetterByteCodes(field, className);
            Class<?> type = this.createClass(className, bytes, field.getDeclaringClass().getClassLoader());
            setter = (Setter)type.newInstance();
            this.setterCache.putIfAbsent(field, setter);
        }
        return setter;
    }

    public Class<?> createClass(String className, byte[] bytes, ClassLoader declaringClassLoader) {
        return this.factoryClassLoader.registerClass(className, bytes, declaringClassLoader);
    }

    public <T, P> Getter<T, P> createGetter(Method m) throws Exception {
        Getter getter = (Getter)this.getterCache.get(m);
        if (getter == null) {
            String className = this.generateClassNameForGetter(m);
            byte[] bytes = this.generateGetterByteCodes(m, className);
            Class<?> type = this.createClass(className, bytes, m.getDeclaringClass().getClassLoader());
            getter = (Getter)type.newInstance();
            this.getterCache.putIfAbsent(m, getter);
        }
        return getter;
    }

    public <T, P> Getter<T, P> createGetter(Field m) throws Exception {
        Getter getter = (Getter)this.getterCache.get(m);
        if (getter == null) {
            String className = this.generateClassNameForGetter(m);
            byte[] bytes = this.generateGetterByteCodes(m, className);
            Class<?> type = this.createClass(className, bytes, m.getDeclaringClass().getClassLoader());
            getter = (Getter)type.newInstance();
            this.getterCache.putIfAbsent(m, getter);
        }
        return getter;
    }

    private byte[] generateGetterByteCodes(Method m, String className) throws Exception {
        Class<?> propertyType = m.getReturnType();
        if (propertyType.isPrimitive()) {
            return GetterBuilder.createPrimitiveGetter(className, m);
        }
        return GetterBuilder.createObjectGetter(className, m);
    }

    private byte[] generateGetterByteCodes(Field m, String className) throws Exception {
        Class<?> propertyType = m.getType();
        if (propertyType.isPrimitive()) {
            return GetterBuilder.createPrimitiveGetter(className, m);
        }
        return GetterBuilder.createObjectGetter(className, m);
    }

    private byte[] generateSetterByteCodes(Method m, String className) throws Exception {
        Class<?> propertyType = m.getParameterTypes()[0];
        if (propertyType.isPrimitive()) {
            return SetterBuilder.createPrimitiveSetter(className, m);
        }
        return SetterBuilder.createObjectSetter(className, m);
    }

    private byte[] generateSetterByteCodes(Field m, String className) throws Exception {
        Class<?> propertyType = m.getType();
        if (propertyType.isPrimitive()) {
            return SetterBuilder.createPrimitiveSetter(className, m);
        }
        return SetterBuilder.createObjectSetter(className, m);
    }

    public <S, T> Instantiator<S, T> createEmptyArgsInstantiator(Class<S> source, Class<? extends T> target) throws Exception {
        InstantiatorKey<S> instantiatorKey = new InstantiatorKey<S>(target, source);
        Class<?> instantiatorType = (Class<?>)this.instantiatorCache.get(instantiatorKey);
        if (instantiatorType == null) {
            String className = this.generateClassNameForInstantiator(instantiatorKey);
            byte[] bytes = ConstructorBuilder.createEmptyConstructor(className, source, target);
            instantiatorType = this.createClass(className, bytes, target.getClassLoader());
            this.instantiatorCache.putIfAbsent(instantiatorKey, instantiatorType);
        }
        return (Instantiator)instantiatorType.newInstance();
    }

    public <S, T> Instantiator<S, T> createInstantiator(Class<S> source, InstantiatorDefinition instantiatorDefinition, Map<Parameter, Getter<? super S, ?>> injections, boolean builderIgnoresNullValues) throws Exception {
        InstantiatorKey<S> instantiatorKey = new InstantiatorKey<S>(instantiatorDefinition, injections, source);
        Class<?> instantiator = (Class<?>)this.instantiatorCache.get(instantiatorKey);
        Instantiator<? super S, T> builderInstantiator = null;
        if (instantiator == null) {
            byte[] bytes;
            String className = this.generateClassNameForInstantiator(instantiatorKey);
            if (instantiatorDefinition instanceof ExecutableInstantiatorDefinition) {
                bytes = InstantiatorBuilder.createInstantiator(className, source, (ExecutableInstantiatorDefinition)instantiatorDefinition, injections);
            } else {
                builderInstantiator = this.createInstantiator(Void.class, ((BuilderInstantiatorDefinition)instantiatorDefinition).getBuilderInstantiator(), new HashMap(), builderIgnoresNullValues);
                bytes = InstantiatorBuilder.createInstantiator(className, source, (BuilderInstantiatorDefinition)instantiatorDefinition, injections, builderIgnoresNullValues);
            }
            instantiator = this.createClass(className, bytes, instantiatorKey.getDeclaringClass().getClassLoader());
            this.instantiatorCache.put(instantiatorKey, instantiator);
        }
        HashMap getterPerName = new HashMap();
        for (Map.Entry<Parameter, Getter<S, ?>> e : injections.entrySet()) {
            getterPerName.put(e.getKey().getName(), e.getValue());
        }
        if (instantiatorDefinition instanceof ExecutableInstantiatorDefinition) {
            return (Instantiator)instantiator.getConstructor(Map.class).newInstance(getterPerName);
        }
        return (Instantiator)instantiator.getConstructor(Map.class, Instantiator.class).newInstance(getterPerName, builderInstantiator);
    }

    public <S1, S2, T> BiInstantiator<S1, S2, T> createBiInstantiator(Class<?> s1, Class<?> s2, InstantiatorDefinition instantiatorDefinition, Map<Parameter, BiFunction<? super S1, ? super S2, ?>> injections, boolean builderIgnoresNullValues) throws Exception {
        BiInstantiatorKey instantiatorKey = new BiInstantiatorKey(instantiatorDefinition, injections, s1, s2);
        Class<?> instantiator = (Class<?>)this.biInstantiatorCache.get(instantiatorKey);
        Instantiator builderInstantiator = null;
        if (instantiator == null) {
            byte[] bytes;
            String className = this.generateClassNameForBiInstantiator(instantiatorKey);
            if (instantiatorDefinition instanceof ExecutableInstantiatorDefinition) {
                bytes = BiInstantiatorBuilder.createInstantiator(className, s1, s2, (ExecutableInstantiatorDefinition)instantiatorDefinition, injections);
            } else {
                builderInstantiator = this.createInstantiator(Void.class, ((BuilderInstantiatorDefinition)instantiatorDefinition).getBuilderInstantiator(), new HashMap(), builderIgnoresNullValues);
                bytes = BiInstantiatorBuilder.createInstantiator(className, s1, s2, builderInstantiator, (BuilderInstantiatorDefinition)instantiatorDefinition, injections, builderIgnoresNullValues);
            }
            instantiator = this.createClass(className, bytes, instantiatorKey.getDeclaringClass().getClassLoader());
            this.biInstantiatorCache.put(instantiatorKey, instantiator);
        }
        HashMap factoryPerName = new HashMap();
        for (Map.Entry<Parameter, BiFunction<S1, S2, ?>> e : injections.entrySet()) {
            factoryPerName.put(e.getKey().getName(), e.getValue());
        }
        if (instantiatorDefinition instanceof ExecutableInstantiatorDefinition) {
            return (BiInstantiator)instantiator.getConstructor(Map.class).newInstance(factoryPerName);
        }
        return (BiInstantiator)instantiator.getConstructor(Map.class, Instantiator.class).newInstance(factoryPerName, builderInstantiator);
    }

    private String generateClassNameForInstantiator(InstantiatorKey key) {
        StringBuilder sb = new StringBuilder();
        sb.append("org.simpleflatmapper.reflect.generated.").append(this.getPackageName(key.getDeclaringClass())).append(".AsmInstantiator").append(key.getDeclaringClass().getSimpleName());
        sb.append("From");
        sb.append(this.replaceArray(key.getSource().getSimpleName()));
        String[] injectedParams = key.getInjectedParams();
        if (injectedParams != null && injectedParams.length > 0) {
            sb.append("Into");
            int e = Math.min(16, injectedParams.length);
            for (int i = 0; i < e; ++i) {
                if (i != 0) {
                    sb.append("And");
                }
                sb.append(injectedParams[i]);
            }
            int l = injectedParams.length - e;
            if (l > 0) {
                sb.append("And").append(Integer.toString(l)).append("More");
            }
        }
        sb.append("_I").append(Long.toHexString(this.classNumber.getAndIncrement()));
        return sb.toString();
    }

    private String generateClassNameForBiInstantiator(BiInstantiatorKey key) {
        StringBuilder sb = new StringBuilder();
        sb.append("org.simpleflatmapper.reflect.generated.").append(this.getPackageName(key.getDeclaringClass())).append(".AsmBiInstantiator").append(key.getDeclaringClass().getSimpleName());
        sb.append("From");
        sb.append(this.replaceArray(key.getS1().getSimpleName()));
        sb.append("And");
        sb.append(this.replaceArray(key.getS2().getSimpleName()));
        String[] injectedParams = key.getInjectedParams();
        if (injectedParams != null && injectedParams.length > 0) {
            sb.append("Into");
            int e = Math.min(16, injectedParams.length);
            for (int i = 0; i < e; ++i) {
                if (i != 0) {
                    sb.append("And");
                }
                sb.append(injectedParams[i]);
            }
            int l = injectedParams.length - e;
            if (l > 0) {
                sb.append("And").append(Integer.toString(l)).append("More");
            }
        }
        sb.append("_I").append(Long.toHexString(this.classNumber.getAndIncrement()));
        return sb.toString();
    }

    public String replaceArray(String simpleName) {
        return simpleName.replace('[', 's').replace(']', '_');
    }

    private String generateClassNameForSetter(Method m) {
        return "org.simpleflatmapper.reflect.generated." + m.getDeclaringClass().getCanonicalName() + "AsmMethodSetter_" + m.getName() + "_" + this.replaceArray(m.getParameterTypes()[0].getSimpleName());
    }

    private String generateClassNameForSetter(Field field) {
        return "org.simpleflatmapper.reflect.generated." + field.getDeclaringClass().getCanonicalName() + "AsmFieldSetter_" + field.getName() + "_" + this.replaceArray(field.getType().getSimpleName());
    }

    private String generateClassNameForGetter(Method m) {
        return "org.simpleflatmapper.reflect.generated." + m.getDeclaringClass().getCanonicalName() + "AsmMethodGetter_" + m.getName();
    }

    private String generateClassNameForGetter(Field m) {
        return "org.simpleflatmapper.reflect.generated." + m.getDeclaringClass().getCanonicalName() + "AsmFieldGetter_" + m.getName();
    }

    public String getPackageName(Type target) {
        Package targetPackage = TypeHelper.toClass((Type)target).getPackage();
        return targetPackage != null ? (targetPackage.getName().isEmpty() ? "none" : targetPackage.getName()) : "none";
    }

    public long getNextClassNumber() {
        return this.classNumber.getAndIncrement();
    }

    public <T> T registerOrCreate(Class<T> clazz, UnaryFactory<AsmFactory, T> factory) {
        T tPresent;
        Object t = clazz.cast(this.subFactories.get(clazz));
        if (t == null && (tPresent = clazz.cast(this.subFactories.putIfAbsent(clazz, t = factory.newInstance((Object)this)))) != null) {
            return tPresent;
        }
        return t;
    }
}

