/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.asm;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simpleflatmapper.ow2asm.ClassReader;
import org.simpleflatmapper.ow2asm.ClassVisitor;
import org.simpleflatmapper.ow2asm.Label;
import org.simpleflatmapper.ow2asm.MethodVisitor;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.asm.AsmUtils;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.TypeHelper;

public class AsmInstantiatorDefinitionFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<InstantiatorDefinition> extractDefinitions(final Type target) throws IOException {
        final ArrayList<InstantiatorDefinition> constructors = new ArrayList<InstantiatorDefinition>();
        final Class targetClass = TypeHelper.toClass((Type)target);
        ClassLoader cl = targetClass.getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        String fileName = targetClass.getName().replace('.', '/') + ".class";
        InputStream is = cl.getResourceAsStream(fileName);
        try {
            if (is == null) {
                throw new IOException("Cannot find file " + fileName + " in " + cl);
            }
            ClassReader classReader = new ClassReader(is);
            classReader.accept(new ClassVisitor(327680){
                List<String> genericTypeNames;

                @Override
                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    this.genericTypeNames = signature != null ? AsmUtils.extractGenericTypeNames(signature) : Collections.emptyList();
                    super.visit(version, access, name, signature, superName, interfaces);
                }

                @Override
                public MethodVisitor visitMethod(int access, final String methodName, String desc, String signature, String[] exceptions) {
                    final boolean isConstructor = "<init>".equals(methodName);
                    if ((1 & access) == 1 && (isConstructor || (8 & access) == 8 && !desc.endsWith("V"))) {
                        List<String> genericTypes;
                        ArrayList names;
                        List<String> descTypes;
                        block6: {
                            descTypes = AsmUtils.extractTypeNamesFromSignature(desc);
                            names = new ArrayList();
                            genericTypes = signature != null ? AsmUtils.extractTypeNamesFromSignature(signature) : descTypes;
                            if (!isConstructor) {
                                if (descTypes.size() > 0) {
                                    try {
                                        Type genericType = AsmUtils.toGenericType(descTypes.get(descTypes.size() - 1), this.genericTypeNames, target);
                                        if (!targetClass.isAssignableFrom(TypeHelper.toClass((Type)genericType))) {
                                            return null;
                                        }
                                        break block6;
                                    }
                                    catch (ClassNotFoundException e) {
                                        return null;
                                    }
                                }
                                return null;
                            }
                        }
                        return new MethodVisitor(327680){
                            Label firstLabel;
                            Label lastLabel;

                            @Override
                            public void visitLabel(Label label) {
                                if (this.firstLabel == null) {
                                    this.firstLabel = label;
                                }
                                this.lastLabel = label;
                            }

                            @Override
                            public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                                if (start.equals(this.firstLabel) && end.equals(this.lastLabel) && !"this".equals(name)) {
                                    names.add(name);
                                }
                            }

                            @Override
                            public void visitEnd() {
                                try {
                                    ArrayList<Parameter> parameters = new ArrayList<Parameter>();
                                    int l = descTypes.size() - (isConstructor ? 0 : 1);
                                    for (int i = 0; i < l; ++i) {
                                        String name = "arg" + i;
                                        if (i < names.size()) {
                                            name = (String)names.get(i);
                                        }
                                        parameters.add(this.createParameter(i, name, (String)descTypes.get(i), (String)genericTypes.get(i)));
                                    }
                                    Executable executable = isConstructor ? targetClass.getDeclaredConstructor(this.toTypeArray(parameters)) : targetClass.getDeclaredMethod(methodName, this.toTypeArray(parameters));
                                    constructors.add(new ExecutableInstantiatorDefinition(executable, parameters.toArray(new Parameter[0])));
                                }
                                catch (Exception e) {
                                    ErrorHelper.rethrow((Throwable)e);
                                }
                            }

                            private Class<?>[] toTypeArray(List<Parameter> parameters) {
                                Class[] types = new Class[parameters.size()];
                                for (int i = 0; i < types.length; ++i) {
                                    types[i] = parameters.get(i).getType();
                                }
                                return types;
                            }

                            private Parameter createParameter(int index, String name, String desc, String signature) {
                                try {
                                    Type type;
                                    Type basicType;
                                    Type genericType = basicType = AsmUtils.toGenericType(desc, genericTypeNames, target);
                                    if (signature != null && (type = AsmUtils.toGenericType(signature, genericTypeNames, target)) != null) {
                                        genericType = type;
                                    }
                                    return new Parameter(index, name, TypeHelper.toClass((Type)basicType), genericType);
                                }
                                catch (ClassNotFoundException e) {
                                    throw new Error("Unexpected error " + e, e);
                                }
                            }
                        };
                    }
                    return null;
                }
            }, 0);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return constructors;
    }
}

