/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.simpleflatmapper.converter.Converter;
import org.simpleflatmapper.converter.ConverterService;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.MapPropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeHelper;

public class MapClassMeta<M extends Map<K, V>, K, V>
implements ClassMeta<M> {
    private final ReflectionService reflectionService;
    private final Converter<? super CharSequence, ? extends K> keyConverter;
    private final ClassMeta<V> valueClassMeta;
    private final Type type;
    private final Constructor<?> constructor;

    public MapClassMeta(Type type, Type keyType, Type valueType, ReflectionService reflectionService) {
        this.type = type;
        this.keyConverter = ConverterService.getInstance().findConverter(CharSequence.class, keyType, new Object[0]);
        if (this.keyConverter == null) {
            throw new IllegalArgumentException("Unsupported key type " + keyType);
        }
        this.reflectionService = reflectionService;
        this.valueClassMeta = reflectionService.getClassMeta(valueType);
        this.constructor = this.getConstructor(type);
    }

    private Constructor<?> getConstructor(Type type) {
        Class<?> implClass = this.findMapImpl(type);
        try {
            return implClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No empty constructor for " + implClass);
        }
    }

    private Class<?> findMapImpl(Type type) {
        Class clazz = TypeHelper.toClass((Type)type);
        if (clazz.isInterface()) {
            if (Map.class.equals((Object)clazz)) {
                return HashMap.class;
            }
            if (ConcurrentMap.class.equals((Object)clazz)) {
                return ConcurrentHashMap.class;
            }
        } else if (!Modifier.isAbstract(clazz.getModifiers())) {
            return clazz;
        }
        throw new IllegalArgumentException("No known Map impl for " + type);
    }

    @Override
    public ReflectionService getReflectionService() {
        return this.reflectionService;
    }

    @Override
    public PropertyFinder<M> newPropertyFinder(Predicate<PropertyMeta<?, ?>> propertyFilter) {
        return new MapPropertyFinder(this, this.valueClassMeta, this.keyConverter, propertyFilter, this.reflectionService.selfScoreFullName());
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public List<InstantiatorDefinition> getInstantiatorDefinitions() {
        return Arrays.asList(new ExecutableInstantiatorDefinition(this.constructor, new Parameter[0]));
    }

    @Override
    public void forEachProperties(Consumer<? super PropertyMeta<M, ?>> consumer) {
        throw new UnsupportedOperationException("Cannot list properties as non static");
    }

    @Override
    public int getNumberOfProperties() {
        return 10000;
    }
}

