/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.getter.NullGetter;
import org.simpleflatmapper.reflect.meta.PropertyMatchingScore;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;
import org.simpleflatmapper.reflect.setter.NullSetter;
import org.simpleflatmapper.util.Predicate;

public abstract class PropertyFinder<T> {
    protected final Predicate<PropertyMeta<?, ?>> propertyFilter;
    public static PropertyFinderTransformer IDENTITY_TRANSFORMER = new PropertyFinderTransformer(){

        @Override
        public <T> PropertyFinder<T> apply(PropertyFinder<T> propertyFinder) {
            return propertyFinder;
        }

        public String toString() {
            return "IDENTITY_TRANSFORMER";
        }
    };

    protected PropertyFinder(Predicate<PropertyMeta<?, ?>> propertyFilter) {
        this.propertyFilter = propertyFilter;
    }

    public final <E> PropertyMeta<T, E> findProperty(PropertyNameMatcher propertyNameMatcher) {
        return this.findProperty(propertyNameMatcher, new DefaultPropertyFinderProbe(propertyNameMatcher));
    }

    public final <E> PropertyMeta<T, E> findProperty(PropertyNameMatcher propertyNameMatcher, PropertyFinderProbe propertyFinderProbe) {
        MatchingProperties matchingProperties = new MatchingProperties(this.propertyFilter, propertyFinderProbe);
        this.lookForProperties(propertyNameMatcher, matchingProperties, PropertyMatchingScore.INITIAL, true, IDENTITY_TRANSFORMER);
        return matchingProperties.selectBestMatch();
    }

    public abstract void lookForProperties(PropertyNameMatcher var1, FoundProperty<T> var2, PropertyMatchingScore var3, boolean var4, PropertyFinderTransformer var5);

    public abstract List<InstantiatorDefinition> getEligibleInstantiatorDefinitions();

    public abstract PropertyFinder<?> getSubPropertyFinder(PropertyMeta<?, ?> var1);

    public abstract PropertyFinder<?> getOrCreateSubPropertyFinder(SubPropertyMeta<?, ?, ?> var1);

    public Predicate<PropertyMeta<?, ?>> getPropertyFilter() {
        return this.propertyFilter;
    }

    public abstract Type getOwnerType();

    public void manualMatch(PropertyMeta<?, ?> prop) {
        if (prop.isSubProperty()) {
            SubPropertyMeta subPropertyMeta = (SubPropertyMeta)prop;
            PropertyMeta ownerProperty = subPropertyMeta.getOwnerProperty();
            this.manualMatch(ownerProperty);
            PropertyFinder subPropertyFinder = this.getOrCreateSubPropertyFinder(subPropertyMeta);
            subPropertyFinder.manualMatch(subPropertyMeta.getSubProperty());
        }
    }

    public static class DefaultPropertyFinderProbe
    implements PropertyFinderProbe {
        private static final boolean DEBUG = Boolean.getBoolean("org.simpleflatmapper.probe.propertyFinder");
        private final PropertyNameMatcher propertyNameMatcher;

        public DefaultPropertyFinderProbe(PropertyNameMatcher propertyNameMatcher) {
            this.propertyNameMatcher = propertyNameMatcher;
        }

        @Override
        public void found(PropertyMeta propertyMeta, PropertyMatchingScore score) {
            if (DEBUG) {
                System.out.println("PropertyFinder for '" + this.propertyNameMatcher + "' - found " + score + " " + propertyMeta.getPath());
            }
        }

        @Override
        public void select(PropertyMeta propertyMeta) {
            if (DEBUG) {
                System.out.println("PropertyFinder for '" + this.propertyNameMatcher + "' - select " + propertyMeta.getPath());
            }
        }
    }

    public static interface PropertyFinderProbe {
        public void found(PropertyMeta var1, PropertyMatchingScore var2);

        public void select(PropertyMeta var1);
    }

    public static interface PropertyFinderTransformer {
        public <T> PropertyFinder<T> apply(PropertyFinder<T> var1);
    }

    public static interface FoundProperty<T> {
        public <P extends PropertyMeta<T, ?>> void found(P var1, Runnable var2, PropertyMatchingScore var3);
    }

    private static class MatchedProperty<T, P extends PropertyMeta<T, ?>>
    implements Comparable<MatchedProperty<T, ?>> {
        private final P propertyMeta;
        private final Runnable selectionCallback;
        private final PropertyMatchingScore score;

        private MatchedProperty(P propertyMeta, Runnable selectionCallback, PropertyMatchingScore score) {
            this.propertyMeta = propertyMeta;
            this.selectionCallback = selectionCallback;
            this.score = score;
        }

        @Override
        public int compareTo(MatchedProperty<T, ?> o) {
            int i = this.score.compareTo(o.score);
            if (i == 0) {
                return this.compare((PropertyMeta<?, ?>)this.propertyMeta, (PropertyMeta<?, ?>)o.propertyMeta);
            }
            return i;
        }

        private int compare(PropertyMeta<?, ?> p1, PropertyMeta<?, ?> p2) {
            if (p1.isConstructorProperty()) {
                if (!p2.isConstructorProperty()) {
                    return -1;
                }
            } else {
                if (p2.isConstructorProperty()) {
                    return 1;
                }
                if (!p1.isSelf()) {
                    if (p2.isSelf()) {
                        return -1;
                    }
                } else {
                    if (!p2.isSelf()) {
                        return 1;
                    }
                    if (!p1.isSubProperty()) {
                        if (p2.isSubProperty()) {
                            return -1;
                        }
                    } else if (!p2.isSubProperty()) {
                        return 1;
                    }
                }
            }
            return this.getterSetterCompare(p1, p2);
        }

        private int getterSetterCompare(PropertyMeta<?, ?> p1, PropertyMeta<?, ?> p2) {
            return this.nbGetterSetter(p2) - this.nbGetterSetter(p1);
        }

        private int nbGetterSetter(PropertyMeta<?, ?> p) {
            int c = 0;
            if (!NullGetter.isNull(p.getGetter())) {
                ++c;
            }
            if (!NullSetter.isNull(p.getSetter())) {
                ++c;
            }
            return c;
        }

        public void select() {
            if (this.selectionCallback != null) {
                this.selectionCallback.run();
            }
        }

        public String toString() {
            return "MatchedProperty{propertyMeta=" + this.propertyMeta + ", score=" + this.score + ":" + this.nbGetterSetter((PropertyMeta<?, ?>)this.propertyMeta) + ", getter=" + ((PropertyMeta)this.propertyMeta).getGetter() + ", setter=" + ((PropertyMeta)this.propertyMeta).getSetter() + '}';
        }

        /* synthetic */ MatchedProperty(PropertyMeta x0, Runnable x1, PropertyMatchingScore x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    protected static class MatchingProperties<T>
    implements FoundProperty<T> {
        private final List<MatchedProperty<T, ?>> matchedProperties = new ArrayList();
        private final Predicate<PropertyMeta<?, ?>> propertyFilter;
        private final PropertyFinderProbe propertyFinderProbe;

        public MatchingProperties(Predicate<PropertyMeta<?, ?>> propertyFilter, PropertyFinderProbe propertyFinderProbe) {
            this.propertyFilter = propertyFilter;
            this.propertyFinderProbe = propertyFinderProbe;
        }

        @Override
        public <P extends PropertyMeta<T, ?>> void found(P propertyMeta, Runnable selectionCallback, PropertyMatchingScore score) {
            if (this.propertyFilter.test(propertyMeta)) {
                this.propertyFinderProbe.found(propertyMeta, score);
                this.matchedProperties.add(new MatchedProperty(propertyMeta, selectionCallback, score, null));
            }
        }

        public PropertyMeta<T, ?> selectBestMatch() {
            if (this.matchedProperties.isEmpty()) {
                return null;
            }
            Collections.sort(this.matchedProperties);
            MatchedProperty<T, ?> selectedMatchedProperty = this.matchedProperties.get(0);
            selectedMatchedProperty.select();
            this.propertyFinderProbe.select(((MatchedProperty)selectedMatchedProperty).propertyMeta);
            return ((MatchedProperty)selectedMatchedProperty).propertyMeta;
        }
    }
}

