/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.simpleflatmapper.reflect.BiInstantiator;
import org.simpleflatmapper.reflect.Instantiator;
import org.simpleflatmapper.reflect.MethodBiFunctionPair;
import org.simpleflatmapper.util.ErrorHelper;

public final class BuilderBiInstantiator<S1, S2, T>
implements BiInstantiator<S1, S2, T> {
    private final Instantiator<Void, ?> builderInstantiator;
    private final MethodBiFunctionPair<S1, S2>[] chainedArguments;
    private final MethodBiFunctionPair<S1, S2>[] unchainedArguments;
    private final Method buildMethod;
    private final boolean ignoreNullValues;

    public BuilderBiInstantiator(Instantiator<Void, ?> builderInstantiator, MethodBiFunctionPair<S1, S2>[] chainedArguments, MethodBiFunctionPair<S1, S2>[] unchainedArguments, Method buildMethod, boolean ignoreNullValues) {
        this.builderInstantiator = builderInstantiator;
        this.chainedArguments = chainedArguments;
        this.unchainedArguments = unchainedArguments;
        this.buildMethod = buildMethod;
        this.ignoreNullValues = ignoreNullValues;
    }

    @Override
    public T newInstance(S1 s1, S2 s2) throws Exception {
        try {
            Object v;
            Object builder = this.builderInstantiator.newInstance(null);
            for (MethodBiFunctionPair<S1, S2> argument : this.chainedArguments) {
                v = argument.getFunction().apply(s1, s2);
                if (this.ignoreNullValues && v == null) continue;
                builder = argument.getMethod().invoke(builder, v);
            }
            for (MethodBiFunctionPair<S1, S2> argument : this.unchainedArguments) {
                v = argument.getFunction().apply(s1, s2);
                if (this.ignoreNullValues && v == null) continue;
                argument.getMethod().invoke(builder, v);
            }
            return (T)this.buildMethod.invoke(builder, new Object[0]);
        }
        catch (InvocationTargetException e) {
            return (T)ErrorHelper.rethrow((Throwable)e.getCause());
        }
    }
}

