/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import org.simpleflatmapper.reflect.meta.AbstractIndexPropertyFinder;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.IndexedColumn;
import org.simpleflatmapper.reflect.meta.IndexedElement;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMatchingScore;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;
import org.simpleflatmapper.reflect.meta.TupleClassMeta;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.Predicate;

public class TuplePropertyFinder<T>
extends AbstractIndexPropertyFinder<T> {
    public TuplePropertyFinder(final TupleClassMeta<T> tupleClassMeta, Predicate<PropertyMeta<?, ?>> propertyFilter) {
        super(tupleClassMeta, propertyFilter);
        tupleClassMeta.forEachProperties(new Consumer<PropertyMeta<T, ?>>(){

            public void accept(PropertyMeta<T, ?> propertyMeta) {
                TuplePropertyFinder.this.elements.add(TuplePropertyFinder.this.newIndexedElement(tupleClassMeta, propertyMeta));
            }
        });
    }

    private <E> IndexedElement<T, E> newIndexedElement(TupleClassMeta<T> tupleClassMeta, PropertyMeta<T, E> prop) {
        ClassMeta classMeta = tupleClassMeta.getReflectionService().getClassMeta(prop.getPropertyType());
        return new IndexedElement<T, E>(prop, classMeta, this.propertyFilter);
    }

    @Override
    protected boolean isValidIndex(IndexedColumn indexedColumn) {
        return indexedColumn.getIndexValue() < this.elements.size();
    }

    @Override
    protected IndexedElement<T, ?> getIndexedElement(IndexedColumn indexedColumn) {
        return (IndexedElement)this.elements.get(indexedColumn.getIndexValue());
    }

    @Override
    protected void extrapolateIndex(PropertyNameMatcher propertyNameMatcher, final PropertyFinder.FoundProperty foundProperty, PropertyMatchingScore score, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer) {
        for (int i = 0; i < this.elements.size(); ++i) {
            final IndexedElement element = (IndexedElement)this.elements.get(i);
            if (element.getElementClassMeta() != null) {
                propertyFinderTransformer.apply(element.getPropertyFinder()).lookForProperties(propertyNameMatcher, new PropertyFinder.FoundProperty(){

                    public void found(final PropertyMeta propertyMeta, final Runnable selectionCallback, PropertyMatchingScore score) {
                        if (!element.hasProperty(propertyMeta)) {
                            PropertyMeta<Object, Object> subProperty = propertyMeta.isSelf() ? element.getPropertyMeta() : new SubPropertyMeta(TuplePropertyFinder.this.classMeta.getReflectionService(), element.getPropertyMeta(), propertyMeta);
                            foundProperty.found(subProperty, new Runnable(){

                                @Override
                                public void run() {
                                    element.addProperty(propertyMeta);
                                    selectionCallback.run();
                                }
                            }, score);
                        }
                    }
                }, score, true, propertyFinderTransformer);
            }
            score = score.decrease(1);
        }
    }

    @Override
    public PropertyFinder<?> getSubPropertyFinder(String name) {
        return null;
    }
}

