/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;
import org.simpleflatmapper.reflect.meta.ArrayPropertyFinder;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.TypeHelper;

public class ArrayClassMeta<T, E>
implements ClassMeta<T> {
    private final ReflectionService reflectionService;
    private final Type elementTarget;
    private final ClassMeta<E> elementClassMeta;
    private final Type type;
    private final InstantiatorDefinition constructor;

    public ArrayClassMeta(Type type, Type elementTarget, ReflectionService reflectionService) {
        this.type = type;
        this.elementTarget = elementTarget;
        this.reflectionService = reflectionService;
        this.elementClassMeta = reflectionService.getClassMeta(elementTarget);
        this.constructor = this.getConstructor(type);
    }

    private InstantiatorDefinition getConstructor(Type type) {
        if (TypeHelper.isArray((Type)type)) {
            return null;
        }
        Class<?> implClass = this.findListImpl(type);
        try {
            return new ExecutableInstantiatorDefinition(implClass.getDeclaredConstructor(new Class[0]), new Parameter[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No empty constructor for " + implClass);
        }
    }

    private Class<?> findListImpl(Type type) {
        Class clazz = TypeHelper.toClass((Type)type);
        if (clazz.isInterface()) {
            if (List.class.equals((Object)clazz)) {
                return ArrayList.class;
            }
        } else if (!Modifier.isAbstract(clazz.getModifiers())) {
            return clazz;
        }
        throw new IllegalArgumentException("No known List impl for " + type);
    }

    public ClassMeta<E> getElementClassMeta() {
        return this.elementClassMeta;
    }

    public Type getElementTarget() {
        return this.elementTarget;
    }

    @Override
    public ReflectionService getReflectionService() {
        return this.reflectionService;
    }

    @Override
    public PropertyFinder<T> newPropertyFinder() {
        return new ArrayPropertyFinder(this);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public boolean isArray() {
        return TypeHelper.isArray((Type)this.type);
    }

    @Override
    public List<InstantiatorDefinition> getInstantiatorDefinitions() {
        if (this.constructor != null) {
            return Arrays.asList(this.constructor);
        }
        return Collections.emptyList();
    }

    @Override
    public void forEachProperties(Consumer<? super PropertyMeta<T, ?>> consumer) {
        throw new UnsupportedOperationException("Cannot forEach property on array as variable");
    }
}

