/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.IndexedColumn;
import org.simpleflatmapper.reflect.meta.IndexedElement;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMatchingScore;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatch;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;

public abstract class AbstractIndexPropertyFinder<T>
extends PropertyFinder<T> {
    protected final ClassMeta<T> classMeta;
    protected final List<IndexedElement<T, ?>> elements = new ArrayList();

    public AbstractIndexPropertyFinder(ClassMeta<T> classMeta) {
        this.classMeta = classMeta;
    }

    @Override
    protected void lookForProperties(PropertyNameMatcher propertyNameMatcher, PropertyFinder.FoundProperty<T> matchingProperties, PropertyMatchingScore score, boolean allowSelfReference) {
        IndexedColumn indexedColumn = propertyNameMatcher.matchIndex();
        if (indexedColumn != null) {
            this.lookForAgainstColumn(indexedColumn, matchingProperties, score);
        } else {
            this.extrapolateIndex(propertyNameMatcher, matchingProperties, score.decrease(1));
            this.speculativeMatching(propertyNameMatcher, matchingProperties, score.shift());
        }
    }

    protected void lookForAgainstColumn(IndexedColumn indexedColumn, final PropertyFinder.FoundProperty<T> matchingProperties, PropertyMatchingScore score) {
        if (indexedColumn == null || !this.isValidIndex(indexedColumn)) {
            return;
        }
        final IndexedElement<T, ?> indexedElement = this.getIndexedElement(indexedColumn);
        if (indexedColumn.getSubPropertyNameMatcher() == null) {
            matchingProperties.found(indexedElement.getPropertyMeta(), new Runnable(){

                @Override
                public void run() {
                    if (!indexedElement.hasProperty("{this}")) {
                        indexedElement.addProperty("{this}");
                    }
                }
            }, score);
            return;
        }
        PropertyFinder<?> eltPropertyFinder = indexedElement.getPropertyFinder();
        if (eltPropertyFinder == null) {
            return;
        }
        eltPropertyFinder.lookForProperties(indexedColumn.getSubPropertyNameMatcher(), new PropertyFinder.FoundProperty(){

            public void found(final PropertyMeta propertyMeta, final Runnable selectionCallback, PropertyMatchingScore score) {
                PropertyMeta<Object, Object> subProperty = propertyMeta.isSelf() ? indexedElement.getPropertyMeta() : new SubPropertyMeta(AbstractIndexPropertyFinder.this.classMeta.getReflectionService(), indexedElement.getPropertyMeta(), propertyMeta);
                matchingProperties.found(subProperty, new Runnable(){

                    @Override
                    public void run() {
                        selectionCallback.run();
                        indexedElement.addProperty(propertyMeta);
                    }
                }, score);
            }
        }, score, true);
    }

    private void speculativeMatching(PropertyNameMatcher propertyNameMatcher, PropertyFinder.FoundProperty foundProperty, PropertyMatchingScore score) {
        PropertyNameMatch speculativeMatch = propertyNameMatcher.speculativeMatch();
        if (speculativeMatch != null) {
            this.extrapolateIndex(speculativeMatch.getLeftOverMatcher(), foundProperty, score);
        }
    }

    protected abstract boolean isValidIndex(IndexedColumn var1);

    protected abstract <E> IndexedElement<T, ?> getIndexedElement(IndexedColumn var1);

    protected abstract void extrapolateIndex(PropertyNameMatcher var1, PropertyFinder.FoundProperty var2, PropertyMatchingScore var3);

    @Override
    public List<InstantiatorDefinition> getEligibleInstantiatorDefinitions() {
        return this.classMeta.getInstantiatorDefinitions();
    }
}

