/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.meta.PropertyMatchingScore;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;

public abstract class PropertyFinder<T> {
    public final <E> PropertyMeta<T, E> findProperty(PropertyNameMatcher propertyNameMatcher) {
        MatchingProperties matchingProperties = new MatchingProperties();
        this.lookForProperties(propertyNameMatcher, matchingProperties, PropertyMatchingScore.INITIAL, true);
        return matchingProperties.selectBestMatch();
    }

    protected abstract void lookForProperties(PropertyNameMatcher var1, FoundProperty<T> var2, PropertyMatchingScore var3, boolean var4);

    public abstract List<InstantiatorDefinition> getEligibleInstantiatorDefinitions();

    public abstract PropertyFinder<?> getSubPropertyFinder(String var1);

    public static interface FoundProperty<T> {
        public <P extends PropertyMeta<T, ?>> void found(P var1, Runnable var2, PropertyMatchingScore var3);
    }

    private static class MatchedProperty<T, P extends PropertyMeta<T, ?>>
    implements Comparable<MatchedProperty<T, ?>> {
        private final P propertyMeta;
        private final Runnable selectionCallback;
        private final PropertyMatchingScore score;

        private MatchedProperty(P propertyMeta, Runnable selectionCallback, PropertyMatchingScore score) {
            this.propertyMeta = propertyMeta;
            this.selectionCallback = selectionCallback;
            this.score = score;
        }

        @Override
        public int compareTo(MatchedProperty<T, ?> o) {
            return this.score.compareTo(o.score);
        }

        public void select() {
            if (this.selectionCallback != null) {
                this.selectionCallback.run();
            }
        }

        /* synthetic */ MatchedProperty(PropertyMeta x0, Runnable x1, PropertyMatchingScore x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    protected static class MatchingProperties<T>
    implements FoundProperty<T> {
        private final List<MatchedProperty<T, ?>> matchedProperties = new ArrayList();

        protected MatchingProperties() {
        }

        @Override
        public <P extends PropertyMeta<T, ?>> void found(P propertyMeta, Runnable selectionCallback, PropertyMatchingScore score) {
            this.matchedProperties.add(new MatchedProperty(propertyMeta, selectionCallback, score, null));
        }

        public PropertyMeta<T, ?> selectBestMatch() {
            if (this.matchedProperties.isEmpty()) {
                return null;
            }
            Collections.sort(this.matchedProperties);
            MatchedProperty<T, ?> selectedMatchedProperty = this.matchedProperties.get(0);
            selectedMatchedProperty.select();
            return ((MatchedProperty)selectedMatchedProperty).propertyMeta;
        }
    }
}

