/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simpleflatmapper.converter.Converter;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.DirectClassMeta;
import org.simpleflatmapper.reflect.meta.MapElementPropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcherKeyValuePair;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;
import org.simpleflatmapper.util.ErrorHelper;

public class MapPropertyFinder<T extends Map<K, V>, K, V>
implements PropertyFinder<T> {
    private final ClassMeta<V> valueMetaData;
    private final ClassMeta<T> mapMeta;
    private final Converter<? super CharSequence, ? extends K> keyConverter;
    private final Map<PropertyNameMatcher, PropertyFinder<V>> finders = new HashMap<PropertyNameMatcher, PropertyFinder<V>>();
    private final Map<String, MapElementPropertyMeta<?, K, V>> keys = new HashMap();

    public MapPropertyFinder(ClassMeta<T> mapMeta, ClassMeta<V> valueMetaData, Converter<? super CharSequence, ? extends K> keyConverter) {
        this.mapMeta = mapMeta;
        this.valueMetaData = valueMetaData;
        this.keyConverter = keyConverter;
    }

    @Override
    public <E> PropertyMeta<T, E> findProperty(PropertyNameMatcher propertyNameMatcher) {
        try {
            for (PropertyNameMatcherKeyValuePair keyValue : propertyNameMatcher.keyValuePairs()) {
                PropertyMeta propertyMeta;
                PropertyNameMatcher keyMatcher = keyValue.getKey();
                PropertyNameMatcher valueMatcher = keyValue.getValue();
                PropertyFinder<V> propertyFinder = this.finders.get(keyMatcher);
                if (propertyFinder == null) {
                    propertyFinder = this.valueMetaData.newPropertyFinder();
                }
                if ((propertyMeta = propertyFinder.findProperty(valueMatcher)) == null) continue;
                this.finders.put(keyMatcher, propertyFinder);
                if (propertyMeta instanceof DirectClassMeta.DirectPropertyMeta) {
                    return this.keyProperty(keyMatcher);
                }
                return this.newSubPropertyMeta(keyMatcher, propertyMeta);
            }
        }
        catch (Exception e) {
            ErrorHelper.rethrow((Throwable)e);
        }
        return null;
    }

    private <E> PropertyMeta<T, E> newSubPropertyMeta(PropertyNameMatcher keyMatcher, PropertyMeta<V, ?> propertyMeta) throws Exception {
        PropertyMeta<T, E> keyProperty = this.keyProperty(keyMatcher);
        SubPropertyMeta subPropertyMeta = new SubPropertyMeta(this.valueMetaData.getReflectionService(), keyProperty, propertyMeta);
        return subPropertyMeta;
    }

    private <E> PropertyMeta<T, E> keyProperty(PropertyNameMatcher propertyNameMatcher) throws Exception {
        String keyStringValue = propertyNameMatcher.toString();
        MapElementPropertyMeta propertyMeta = this.keys.get(keyStringValue);
        if (propertyMeta == null) {
            MapElementPropertyMeta mapElementPropertyMeta = new MapElementPropertyMeta(propertyNameMatcher, this.valueMetaData.getReflectionService(), this.valueMetaData, this.keyConverter.convert((Object)keyStringValue));
            this.keys.put(keyStringValue, mapElementPropertyMeta);
            propertyMeta = mapElementPropertyMeta;
        }
        return propertyMeta;
    }

    @Override
    public List<InstantiatorDefinition> getEligibleInstantiatorDefinitions() {
        return this.mapMeta.getInstantiatorDefinitions();
    }

    @Override
    public PropertyFinder<?> getSubPropertyFinder(String name) {
        return null;
    }
}

