/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Type;
import java.util.List;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.meta.ArrayClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.util.BooleanSupplier;

public class ListElementPropertyMeta<T, E>
extends PropertyMeta<T, E> {
    private final int index;
    private final ArrayClassMeta<T, E> arrayMetaData;
    private final BooleanSupplier isVerticalList;

    public ListElementPropertyMeta(String name, ReflectionService reflectService, int index, ArrayClassMeta<T, E> arrayMetaData, BooleanSupplier isVerticalList) {
        super(name, reflectService);
        this.index = index;
        this.arrayMetaData = arrayMetaData;
        this.isVerticalList = isVerticalList;
    }

    @Override
    public Setter<T, E> getSetter() {
        if (this.isVerticalList.getAsBoolean()) {
            return new AppendListSetter();
        }
        return new IndexListSetter(this.index);
    }

    @Override
    public Getter<T, E> getGetter() {
        return new IndexListGetter(this.index);
    }

    @Override
    public Type getPropertyType() {
        return this.arrayMetaData.getElementTarget();
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getPath() {
        return this.getName();
    }

    public String toString() {
        return "ListElementPropertyMeta{index=" + this.index + '}';
    }

    private static class AppendListSetter<E>
    implements Setter<List<E>, E> {
        private AppendListSetter() {
        }

        @Override
        public void set(List<E> target, E value) throws Exception {
            target.add(value);
        }

        public String toString() {
            return "AppendListSetter{}";
        }
    }

    private static class IndexListSetter<E>
    implements Setter<List<E>, E> {
        private final int index;

        private IndexListSetter(int index) {
            this.index = index;
        }

        @Override
        public void set(List<E> target, E value) throws Exception {
            while (target.size() <= this.index) {
                target.add(null);
            }
            target.set(this.index, value);
        }
    }

    private static class IndexListGetter<E>
    implements Getter<List<E>, E> {
        private final int index;

        private IndexListGetter(int index) {
            this.index = index;
        }

        @Override
        public E get(List<E> target) throws Exception {
            if (this.index < target.size()) {
                return target.get(this.index);
            }
            return null;
        }
    }
}

