/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.getter.IdentityGetter;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.setter.NullSetter;

public final class DirectClassMeta<T>
implements ClassMeta<T> {
    public static final String[] HEADERS = new String[]{""};
    public static final IdentityGetter IDENTITY_GETTER = new IdentityGetter();
    private final ReflectionService reflectService;
    private final Type target;

    public DirectClassMeta(Type target, ReflectionService reflectService) {
        this.target = target;
        this.reflectService = reflectService;
    }

    @Override
    public ReflectionService getReflectionService() {
        return this.reflectService;
    }

    @Override
    public PropertyFinder<T> newPropertyFinder() {
        return new DirectPropertyFinder();
    }

    @Override
    public Type getType() {
        return this.target;
    }

    @Override
    public String[] generateHeaders() {
        return HEADERS;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public List<InstantiatorDefinition> getInstantiatorDefinitions() {
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectClassMeta that = (DirectClassMeta)o;
        return this.target.equals(that.target);
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public String toString() {
        return "DirectClassMeta{target=" + this.target + '}';
    }

    public class DirectPropertyMeta<E>
    extends PropertyMeta<T, E> {
        private final Type type;

        public DirectPropertyMeta(String name, ReflectionService reflectService, Type type) {
            super(name, reflectService);
            this.type = type;
        }

        @Override
        public Setter<? super T, ? super E> getSetter() {
            return NullSetter.NULL_SETTER;
        }

        @Override
        public Getter<T, E> getGetter() {
            return IDENTITY_GETTER;
        }

        @Override
        public Type getPropertyType() {
            return this.type;
        }

        @Override
        public String getPath() {
            return ".";
        }

        public String toString() {
            return "DirectPropertyMeta{type=" + this.type + ",name=" + this.getName() + '}';
        }

        @Override
        public boolean isDirect() {
            return true;
        }
    }

    public class DirectPropertyFinder
    implements PropertyFinder<T> {
        @Override
        public <E> PropertyMeta<T, E> findProperty(PropertyNameMatcher propertyNameMatcher) {
            return new DirectPropertyMeta("direct", DirectClassMeta.this.reflectService, DirectClassMeta.this.target);
        }

        @Override
        public List<InstantiatorDefinition> getEligibleInstantiatorDefinitions() {
            return null;
        }

        @Override
        public PropertyFinder<?> getSubPropertyFinder(String name) {
            return null;
        }
    }
}

