/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.reflect.meta.AbstractIndexPropertyFinder;
import org.simpleflatmapper.reflect.meta.ArrayClassMeta;
import org.simpleflatmapper.reflect.meta.ArrayElementPropertyMeta;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.IndexedColumn;
import org.simpleflatmapper.reflect.meta.IndexedElement;
import org.simpleflatmapper.reflect.meta.ListElementPropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.util.BooleanSupplier;

public class ArrayPropertyFinder<T, E>
extends AbstractIndexPropertyFinder<T> {
    private final List<IndexedElement<T, E>> elements = new ArrayList<IndexedElement<T, E>>();

    public ArrayPropertyFinder(ArrayClassMeta<T, E> arrayClassMeta) {
        super(arrayClassMeta);
    }

    @Override
    protected IndexedElement<T, E> getIndexedElement(IndexedColumn indexedColumn) {
        while (this.elements.size() <= indexedColumn.getIndexValue()) {
            this.elements.add(new IndexedElement<T, E>(this.newElementPropertyMeta(this.elements.size(), "element" + this.elements.size()), ((ArrayClassMeta)this.classMeta).getElementClassMeta()));
        }
        return this.elements.get(indexedColumn.getIndexValue());
    }

    private PropertyMeta<T, E> newElementPropertyMeta(int index, String name) {
        ArrayClassMeta arrayClassMeta = (ArrayClassMeta)this.classMeta;
        if (arrayClassMeta.isArray()) {
            return new ArrayElementPropertyMeta(name, arrayClassMeta.getReflectionService(), index, arrayClassMeta);
        }
        return new ListElementPropertyMeta(name, arrayClassMeta.getReflectionService(), index, arrayClassMeta, new BooleanSupplier(){

            public boolean getAsBoolean() {
                return ArrayPropertyFinder.this.elements.size() == 1;
            }
        });
    }

    @Override
    protected IndexedColumn extrapolateIndex(PropertyNameMatcher propertyNameMatcher) {
        ClassMeta elementClassMeta = ((ArrayClassMeta)this.classMeta).getElementClassMeta();
        PropertyMeta property = elementClassMeta.newPropertyFinder().findProperty(propertyNameMatcher);
        if (property != null) {
            for (int i = 0; i < this.elements.size(); ++i) {
                IndexedElement<T, E> element = this.elements.get(i);
                if (element.hasProperty(property)) continue;
                return new IndexedColumn(i, propertyNameMatcher);
            }
            return new IndexedColumn(this.elements.size(), propertyNameMatcher);
        }
        return null;
    }

    @Override
    protected boolean isValidIndex(IndexedColumn indexedColumn) {
        return indexedColumn.getIndexValue() >= 0;
    }

    @Override
    public PropertyFinder<?> getSubPropertyFinder(String name) {
        return null;
    }
}

