/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.simpleflatmapper.reflect.meta.AliasProvider;
import org.simpleflatmapper.reflect.meta.AliasProviderFactory;
import org.simpleflatmapper.reflect.meta.ArrayAliasProvider;
import org.simpleflatmapper.reflect.meta.DefaultAliasProvider;

public final class AliasProviderService {
    private static final AliasProvider aliasProvider = AliasProviderService.findAliasProviders();

    private AliasProviderService() {
    }

    private static AliasProvider findAliasProviders() {
        return AliasProviderService.findAliasProviders(ServiceLoader.load(AliasProviderFactory.class));
    }

    private static AliasProvider findAliasProviders(ServiceLoader<AliasProviderFactory> serviceLoader) {
        ArrayList<AliasProvider> providers = new ArrayList<AliasProvider>();
        Iterator<AliasProviderFactory> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            try {
                AliasProviderFactory factory = iterator.next();
                if (!factory.isActive()) continue;
                providers.add(factory.newProvider());
            }
            catch (Throwable e) {
                System.err.println("Unexpected error on listing ConverterFactoryProducer, prop classloader visibility " + e);
            }
        }
        return AliasProviderService.aggregateAliasProvider(providers.toArray(new AliasProvider[0]));
    }

    public static AliasProvider getAliasProvider() {
        return aliasProvider;
    }

    private static AliasProvider aggregateAliasProvider(AliasProvider[] registered) {
        if (registered.length == 0) {
            return new DefaultAliasProvider();
        }
        if (registered.length == 1) {
            return registered[0];
        }
        return new ArrayAliasProvider(registered);
    }
}

