/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.IndexedColumn;
import org.simpleflatmapper.reflect.meta.IndexedElement;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatch;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;

public abstract class AbstractIndexPropertyFinder<T>
implements PropertyFinder<T> {
    protected final ClassMeta<T> classMeta;
    protected final List<IndexedElement<T, ?>> elements;
    private final Map<String, Integer> speculativeIndexes = new HashMap<String, Integer>();

    public AbstractIndexPropertyFinder(ClassMeta<T> classMeta) {
        this.elements = new ArrayList();
        this.classMeta = classMeta;
    }

    @Override
    public <E> PropertyMeta<T, E> findProperty(PropertyNameMatcher propertyNameMatcher) {
        IndexedColumn indexedColumn = propertyNameMatcher.matchesIndex();
        if (indexedColumn == null) {
            indexedColumn = this.extrapolateIndex(propertyNameMatcher);
        }
        if (indexedColumn == null) {
            indexedColumn = this.speculativeMatching(propertyNameMatcher);
        }
        if (indexedColumn == null || !this.isValidIndex(indexedColumn)) {
            return null;
        }
        IndexedElement<T, ?> indexedElement = this.getIndexedElement(indexedColumn);
        if (indexedElement.getElementClassMeta().isLeaf() || indexedColumn.getSubPropertyNameMatcher() == null) {
            indexedElement.addProperty(".");
            return indexedElement.getPropertyMeta();
        }
        PropertyFinder<?> propertyFinder = indexedElement.getPropertyFinder();
        if (propertyFinder == null) {
            return null;
        }
        PropertyMeta subProp = propertyFinder.findProperty(indexedColumn.getSubPropertyNameMatcher());
        if (subProp == null) {
            return null;
        }
        indexedElement.addProperty(subProp);
        return new SubPropertyMeta(this.classMeta.getReflectionService(), indexedElement.getPropertyMeta(), subProp);
    }

    protected abstract boolean isValidIndex(IndexedColumn var1);

    protected abstract <E> IndexedElement<T, ?> getIndexedElement(IndexedColumn var1);

    private IndexedColumn speculativeMatching(PropertyNameMatcher propertyNameMatcher) {
        PropertyNameMatch speculativeMatch = propertyNameMatcher.speculativeMatch();
        IndexedColumn indexedColumn = null;
        if (speculativeMatch != null) {
            Integer index = this.speculativeIndexes.get(speculativeMatch.getProperty());
            if (index == null) {
                indexedColumn = this.extrapolateIndex(speculativeMatch.getLeftOverMatcher());
                if (indexedColumn != null) {
                    this.speculativeIndexes.put(speculativeMatch.getProperty(), indexedColumn.getIndexValue());
                }
            } else {
                indexedColumn = new IndexedColumn(index, speculativeMatch.getLeftOverMatcher());
            }
        }
        return indexedColumn;
    }

    protected abstract IndexedColumn extrapolateIndex(PropertyNameMatcher var1);

    @Override
    public List<InstantiatorDefinition> getEligibleInstantiatorDefinitions() {
        return this.classMeta.getInstantiatorDefinitions();
    }
}

