/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.meta;

import java.util.ArrayList;
import java.util.List;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.PropertyFinder;
import org.sfm.reflect.meta.PropertyMeta;

public class IndexedElement<T, E> {
    private final PropertyMeta<T, E> propertyMeta;
    private final ClassMeta<E> elementClassMeta;
    private final PropertyFinder<E> propertyFinder;
    private final List<String> assignedPath = new ArrayList<String>();

    public IndexedElement(PropertyMeta<T, E> propertyMeta, ClassMeta<E> elementClassMeta) {
        this.propertyMeta = propertyMeta;
        this.elementClassMeta = elementClassMeta;
        this.propertyFinder = elementClassMeta != null ? elementClassMeta.newPropertyFinder() : null;
    }

    public PropertyMeta<T, E> getPropertyMeta() {
        return this.propertyMeta;
    }

    public ClassMeta<E> getElementClassMeta() {
        return this.elementClassMeta;
    }

    public PropertyFinder<E> getPropertyFinder() {
        return this.propertyFinder;
    }

    public void addProperty(PropertyMeta<?, ?> s) {
        this.addProperty(s.getPath());
    }

    public void addProperty(String path) {
        this.assignedPath.add(path);
    }

    public boolean hasProperty(PropertyMeta<?, ?> property) {
        return this.hasProperty(property.getPath());
    }

    public boolean hasProperty(String path) {
        return this.assignedPath.contains(path);
    }
}

