/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.asm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.sfm.csv.CsvColumnKey;
import org.sfm.csv.impl.CellSetter;
import org.sfm.csv.impl.CsvMapperCellHandler;
import org.sfm.csv.impl.CsvMapperCellHandlerFactory;
import org.sfm.csv.impl.DelayedCellSetterFactory;
import org.sfm.csv.impl.ParsingContextFactory;
import org.sfm.jdbc.JdbcMapper;
import org.sfm.map.FieldKey;
import org.sfm.map.FieldMapper;
import org.sfm.map.FieldMapperErrorHandler;
import org.sfm.map.Mapper;
import org.sfm.map.impl.RethrowFieldMapperErrorHandler;
import org.sfm.reflect.Getter;
import org.sfm.reflect.Instantiator;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.Parameter;
import org.sfm.reflect.Setter;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.asm.AsmUtils;
import org.sfm.reflect.asm.ConstructorBuilder;
import org.sfm.reflect.asm.CsvMapperCellHandlerBuilder;
import org.sfm.reflect.asm.CsvMapperKey;
import org.sfm.reflect.asm.FactoryClassLoader;
import org.sfm.reflect.asm.GetterBuilder;
import org.sfm.reflect.asm.InstantiatorBuilder;
import org.sfm.reflect.asm.InstantiatorKey;
import org.sfm.reflect.asm.MapperAsmBuilder;
import org.sfm.reflect.asm.MapperKey;
import org.sfm.reflect.asm.SetterBuilder;

public class AsmFactory {
    private final FactoryClassLoader factoryClassLoader;
    private final ConcurrentMap<Object, Setter<?, ?>> setterCache = new ConcurrentHashMap();
    private final ConcurrentMap<Object, Getter<?, ?>> getterCache = new ConcurrentHashMap();
    private final ConcurrentMap<InstantiatorKey, Class<? extends Instantiator<?, ?>>> instantiatorCache = new ConcurrentHashMap();
    private final ConcurrentMap<MapperKey, Class<? extends JdbcMapper<?>>> jdbcMapperCache = new ConcurrentHashMap();
    private final ConcurrentMap<CsvMapperKey, Class<? extends CsvMapperCellHandlerFactory<?>>> csvMapperCache = new ConcurrentHashMap();
    private final AtomicLong classNumber = new AtomicLong();

    public AsmFactory(ClassLoader cl) {
        this.factoryClassLoader = new FactoryClassLoader(cl);
    }

    public <T, P> Setter<T, P> createSetter(Method m) throws Exception {
        Setter setter = (Setter)this.setterCache.get(m);
        if (setter == null) {
            String className = this.generateClassNameForSetter(m);
            byte[] bytes = this.generateSetterByteCodes(m, className);
            Class<?> type = this.createClass(className, bytes, m.getDeclaringClass().getClassLoader());
            setter = (Setter)type.newInstance();
            this.setterCache.putIfAbsent(m, setter);
        }
        return setter;
    }

    public <T, P> Setter<T, P> createSetter(Field field) throws Exception {
        Setter setter = (Setter)this.setterCache.get(field);
        if (setter == null) {
            String className = this.generateClassNameForSetter(field);
            byte[] bytes = this.generateSetterByteCodes(field, className);
            Class<?> type = this.createClass(className, bytes, field.getDeclaringClass().getClassLoader());
            setter = (Setter)type.newInstance();
            this.setterCache.putIfAbsent(field, setter);
        }
        return setter;
    }

    private Class<?> createClass(String className, byte[] bytes, ClassLoader declaringClassLoader) {
        return this.factoryClassLoader.registerClass(className, bytes, declaringClassLoader);
    }

    public <T, P> Getter<T, P> createGetter(Method m) throws Exception {
        Getter getter = (Getter)this.getterCache.get(m);
        if (getter == null) {
            String className = this.generateClassNameForGetter(m);
            byte[] bytes = this.generateGetterByteCodes(m, className);
            Class<?> type = this.createClass(className, bytes, m.getDeclaringClass().getClassLoader());
            getter = (Getter)type.newInstance();
            this.getterCache.putIfAbsent(m, getter);
        }
        return getter;
    }

    public <T, P> Getter<T, P> createGetter(Field m) throws Exception {
        Getter getter = (Getter)this.getterCache.get(m);
        if (getter == null) {
            String className = this.generateClassNameForGetter(m);
            byte[] bytes = this.generateGetterByteCodes(m, className);
            Class<?> type = this.createClass(className, bytes, m.getDeclaringClass().getClassLoader());
            getter = (Getter)type.newInstance();
            this.getterCache.putIfAbsent(m, getter);
        }
        return getter;
    }

    private byte[] generateGetterByteCodes(Method m, String className) throws Exception {
        Class<?> propertyType = m.getReturnType();
        if (AsmUtils.primitivesClassAndWrapper.contains(propertyType)) {
            return GetterBuilder.createPrimitiveGetter(className, m);
        }
        return GetterBuilder.createObjectGetter(className, m);
    }

    private byte[] generateGetterByteCodes(Field m, String className) throws Exception {
        Class<?> propertyType = m.getType();
        if (AsmUtils.primitivesClassAndWrapper.contains(propertyType)) {
            return GetterBuilder.createPrimitiveGetter(className, m);
        }
        return GetterBuilder.createObjectGetter(className, m);
    }

    private byte[] generateSetterByteCodes(Method m, String className) throws Exception {
        Class<?> propertyType = m.getParameterTypes()[0];
        if (AsmUtils.primitivesClassAndWrapper.contains(propertyType)) {
            return SetterBuilder.createPrimitiveSetter(className, m);
        }
        return SetterBuilder.createObjectSetter(className, m);
    }

    private byte[] generateSetterByteCodes(Field m, String className) throws Exception {
        Class<?> propertyType = m.getType();
        if (AsmUtils.primitivesClassAndWrapper.contains(propertyType)) {
            return SetterBuilder.createPrimitiveSetter(className, m);
        }
        return SetterBuilder.createObjectSetter(className, m);
    }

    public <S, T> Instantiator<S, T> createEmptyArgsInstantiator(Class<S> source, Class<? extends T> target) throws Exception {
        InstantiatorKey instantiatorKey = new InstantiatorKey(target, source);
        Class<?> instantiatorType = (Class<?>)this.instantiatorCache.get(instantiatorKey);
        if (instantiatorType == null) {
            String className = this.generateClassNameForInstantiator(instantiatorKey);
            byte[] bytes = ConstructorBuilder.createEmptyConstructor(className, source, target);
            instantiatorType = this.createClass(className, bytes, target.getClassLoader());
            this.instantiatorCache.putIfAbsent(instantiatorKey, instantiatorType);
        }
        return (Instantiator)instantiatorType.newInstance();
    }

    public <S, T> Instantiator<S, T> createInstantiator(Class<?> source, InstantiatorDefinition instantiatorDefinition, Map<Parameter, Getter<? super S, ?>> injections) throws Exception {
        InstantiatorKey instantiatorKey = new InstantiatorKey(instantiatorDefinition, injections.keySet(), source);
        Class<?> instantiator = (Class<?>)this.instantiatorCache.get(instantiatorKey);
        if (instantiator == null) {
            String className = this.generateClassNameForInstantiator(instantiatorKey);
            byte[] bytes = InstantiatorBuilder.createInstantiator(className, source, instantiatorDefinition, injections);
            instantiator = this.createClass(className, bytes, instantiatorDefinition.getExecutable().getDeclaringClass().getClassLoader());
            this.instantiatorCache.put(instantiatorKey, instantiator);
        }
        HashMap getterPerName = new HashMap();
        for (Map.Entry<Parameter, Getter<S, ?>> e : injections.entrySet()) {
            getterPerName.put(e.getKey().getName(), e.getValue());
        }
        return (Instantiator)instantiator.getConstructor(Map.class).newInstance(getterPerName);
    }

    public <S, T> Mapper<S, T> createMapper(FieldKey<?>[] keys, FieldMapper<S, T>[] mappers, FieldMapper<S, T>[] constructorMappers, Instantiator<? super S, T> instantiator, Class<? super S> source, Class<T> target) throws Exception {
        MapperKey key = new MapperKey((FieldKey[])keys, (FieldMapper[])mappers, (FieldMapper[])constructorMappers, instantiator, target);
        Class<?> type = (Class<?>)this.jdbcMapperCache.get(key);
        if (type == null) {
            String className = this.generateClassNameForJdbcMapper(mappers, constructorMappers, source, target);
            byte[] bytes = MapperAsmBuilder.dump(className, mappers, constructorMappers, source, target);
            type = this.createClass(className, bytes, target.getClass().getClassLoader());
            this.jdbcMapperCache.put(key, type);
        }
        Constructor<?> constructor = type.getDeclaredConstructors()[0];
        return (Mapper)constructor.newInstance(mappers, constructorMappers, instantiator);
    }

    public <T> CsvMapperCellHandlerFactory<T> createCsvMapperCellHandler(Type target, DelayedCellSetterFactory<T, ?>[] delayedCellSetterFactories, CellSetter<T>[] setters, Instantiator<CsvMapperCellHandler<T>, T> instantiator, CsvColumnKey[] keys, ParsingContextFactory parsingContextFactory, FieldMapperErrorHandler<CsvColumnKey> fieldErrorHandler, int maxMethodSize) throws Exception {
        CsvMapperKey key = new CsvMapperKey(keys, setters, delayedCellSetterFactories, instantiator, target, fieldErrorHandler, maxMethodSize);
        Class<?> typeFactory = (Class<?>)this.csvMapperCache.get(key);
        if (typeFactory == null) {
            String className = this.generateClassNameCsvMapperCellHandler(target, delayedCellSetterFactories, setters);
            String factoryName = className + "Factory";
            byte[] bytes = CsvMapperCellHandlerBuilder.createTargetSetterClass(className, delayedCellSetterFactories, setters, target, fieldErrorHandler == null || fieldErrorHandler instanceof RethrowFieldMapperErrorHandler, maxMethodSize);
            byte[] bytesFactory = CsvMapperCellHandlerBuilder.createTargetSetterFactory(factoryName, className, target);
            this.createClass(className, bytes, target.getClass().getClassLoader());
            typeFactory = this.createClass(factoryName, bytesFactory, target.getClass().getClassLoader());
            this.csvMapperCache.put(key, typeFactory);
        }
        return (CsvMapperCellHandlerFactory)typeFactory.getConstructor(Instantiator.class, CsvColumnKey[].class, ParsingContextFactory.class, FieldMapperErrorHandler.class).newInstance(instantiator, keys, parsingContextFactory, fieldErrorHandler);
    }

    private String generateClassNameForInstantiator(InstantiatorKey key) {
        StringBuilder sb = new StringBuilder();
        sb.append("org.sfm.reflect.asm.").append(this.getPackageName(key.getConstructor().getDeclaringClass())).append(".AsmInstantiator").append(key.getConstructor().getDeclaringClass().getSimpleName());
        sb.append("From");
        sb.append(this.replaceArray(key.getSource().getSimpleName()));
        String[] injectedParams = key.getInjectedParams();
        if (injectedParams != null && injectedParams.length > 0) {
            sb.append("Into");
            int e = Math.min(16, injectedParams.length);
            for (int i = 0; i < e; ++i) {
                if (i != 0) {
                    sb.append("And");
                }
                sb.append(injectedParams[i]);
            }
            int l = injectedParams.length - e;
            if (l > 0) {
                sb.append("And").append(Integer.toString(l)).append("More");
            }
        }
        sb.append("_I").append(Long.toHexString(this.classNumber.getAndIncrement()));
        return sb.toString();
    }

    private String replaceArray(String simpleName) {
        return simpleName.replace('[', 's').replace(']', '_');
    }

    private String generateClassNameForSetter(Method m) {
        return "org.sfm.reflect.asm." + this.getPackageName(m.getDeclaringClass()) + ".AsmMethodSetter" + this.replaceArray(m.getDeclaringClass().getSimpleName()) + "_" + m.getName() + "_" + this.replaceArray(m.getParameterTypes()[0].getSimpleName());
    }

    private String generateClassNameForSetter(Field field) {
        return "org.sfm.reflect.asm." + this.getPackageName(field.getDeclaringClass()) + ".AsmFieldSetter" + this.replaceArray(field.getDeclaringClass().getSimpleName()) + "_" + field.getName() + "_" + this.replaceArray(field.getType().getSimpleName());
    }

    private String generateClassNameForGetter(Method m) {
        return "org.sfm.reflect.asm." + this.getPackageName(m.getDeclaringClass()) + ".AsmMethodGetter" + this.replaceArray(m.getDeclaringClass().getSimpleName()) + "_" + m.getName();
    }

    private String generateClassNameForGetter(Field m) {
        return "org.sfm.reflect.asm." + this.getPackageName(m.getDeclaringClass()) + ".AsmFieldGetter" + this.replaceArray(m.getDeclaringClass().getSimpleName()) + "_" + m.getName();
    }

    private <T> String generateClassNameCsvMapperCellHandler(Type target, DelayedCellSetterFactory<T, ?>[] delayedCellSetterFactories, CellSetter<T>[] setters) {
        StringBuilder sb = new StringBuilder();
        sb.append("org.sfm.reflect.asm.").append(this.getPackageName(target)).append(".AsmCsvMapperCellHandlerTo").append(TypeHelper.toClass(target).getSimpleName());
        if (delayedCellSetterFactories.length > 0) {
            sb.append("DS").append(Integer.toString(delayedCellSetterFactories.length));
        }
        if (setters.length > 0) {
            sb.append("S").append(Integer.toString(setters.length));
        }
        sb.append("_I").append(Long.toHexString(this.classNumber.getAndIncrement()));
        return sb.toString();
    }

    private <S, T> String generateClassNameForJdbcMapper(FieldMapper<S, T>[] mappers, FieldMapper<S, T>[] constructorMappers, Class<? super S> source, Class<T> target) {
        StringBuilder sb = new StringBuilder();
        sb.append("org.sfm.reflect.asm.");
        sb.append(this.getPackageName(target));
        sb.append(".AsmMapperFrom").append(this.replaceArray(source.getSimpleName()));
        sb.append("To").append(this.replaceArray(target.getSimpleName()));
        if (constructorMappers.length > 0) {
            sb.append("ConstInj").append(constructorMappers.length);
        }
        if (mappers.length > 0) {
            sb.append("Inj").append(mappers.length);
        }
        sb.append("_I").append(Long.toHexString(this.classNumber.getAndIncrement()));
        return sb.toString();
    }

    private <T> String getPackageName(Type target) {
        Package targetPackage = TypeHelper.toClass(target).getPackage();
        return targetPackage != null ? targetPackage.getName() : ".none";
    }
}

