/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.sfm.jdbc.JdbcColumnKey;
import org.sfm.jdbc.JdbcMapper;
import org.sfm.jdbc.JdbcMappingContextFactoryBuilder;
import org.sfm.jdbc.impl.ResultSetEnumarable;
import org.sfm.jdbc.impl.getter.ResultSetGetterFactory;
import org.sfm.map.GetterFactory;
import org.sfm.map.Mapper;
import org.sfm.map.MappingContext;
import org.sfm.map.MappingContextFactory;
import org.sfm.map.RowHandlerErrorHandler;
import org.sfm.map.column.ColumnProperty;
import org.sfm.map.impl.AbstractMapperBuilder;
import org.sfm.map.impl.FieldMapperColumnDefinition;
import org.sfm.map.impl.JoinMapperImpl;
import org.sfm.map.impl.MapperConfig;
import org.sfm.map.impl.MapperSource;
import org.sfm.map.impl.MapperSourceImpl;
import org.sfm.map.impl.StaticSetRowMapper;
import org.sfm.map.impl.context.MappingContextFactoryBuilder;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.TypeReference;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.utils.Enumarable;
import org.sfm.utils.UnaryFactory;

public final class JdbcMapperBuilder<T>
extends AbstractMapperBuilder<ResultSet, T, JdbcColumnKey, JdbcMapper<T>, JdbcMapperBuilder<T>> {
    public static final MapperSourceImpl<ResultSet, JdbcColumnKey> FIELD_MAPPER_SOURCE = new MapperSourceImpl(ResultSet.class, (GetterFactory)new ResultSetGetterFactory());

    public JdbcMapperBuilder(TypeReference<T> target) {
        this(target.getType());
    }

    public JdbcMapperBuilder(Type target) {
        this(target, ReflectionService.newInstance());
    }

    public JdbcMapperBuilder(Type target, ReflectionService reflectService) {
        this(reflectService.getClassMeta(target), (MapperConfig<JdbcColumnKey, FieldMapperColumnDefinition<JdbcColumnKey, ResultSet>>)MapperConfig.fieldMapperConfig(), (GetterFactory<ResultSet, JdbcColumnKey>)new ResultSetGetterFactory(), new JdbcMappingContextFactoryBuilder());
    }

    public JdbcMapperBuilder(ClassMeta<T> classMeta, MapperConfig<JdbcColumnKey, FieldMapperColumnDefinition<JdbcColumnKey, ResultSet>> mapperConfig, GetterFactory<ResultSet, JdbcColumnKey> getterFactory, MappingContextFactoryBuilder<ResultSet, JdbcColumnKey> parentBuilder) {
        super(classMeta, parentBuilder, mapperConfig, (MapperSource)FIELD_MAPPER_SOURCE.getterFactory(getterFactory), 1);
    }

    public JdbcMapperBuilder<T> addMapping(String column, int index, int sqlType) {
        this.addMapping(column, index, sqlType, (FieldMapperColumnDefinition<JdbcColumnKey, ResultSet>)FieldMapperColumnDefinition.identity());
        return this;
    }

    public JdbcMapperBuilder<T> addMapping(String column, int index, int sqlType, FieldMapperColumnDefinition<JdbcColumnKey, ResultSet> columnDefinition) {
        return (JdbcMapperBuilder)this.addMapping(new JdbcColumnKey(column, index, sqlType), columnDefinition);
    }

    public JdbcMapperBuilder<T> addMapping(String column, int index, int sqlType, ColumnProperty ... properties) {
        return (JdbcMapperBuilder)this.addMapping(new JdbcColumnKey(column, index, sqlType), properties);
    }

    public JdbcMapperBuilder<T> addMapping(ResultSetMetaData metaData) throws SQLException {
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            this.addMapping(metaData.getColumnLabel(i), i, metaData.getColumnType(i));
        }
        return this;
    }

    protected JdbcColumnKey key(String column, int index) {
        return new JdbcColumnKey(column, index);
    }

    protected JdbcMapper<T> newJoinJdbcMapper(Mapper<ResultSet, T> mapper) {
        return new JoinDatastaxMapper<T>(mapper, this.mapperConfig.rowHandlerErrorHandler(), this.mappingContextFactoryBuilder.newFactory());
    }

    protected JdbcMapper<T> newStaticJdbcMapper(Mapper<ResultSet, T> mapper) {
        return new StaticJdbcSetRowMapper<T>(mapper, this.mapperConfig.rowHandlerErrorHandler(), this.mappingContextFactoryBuilder.newFactory());
    }

    public static class StaticJdbcSetRowMapper<T>
    extends StaticSetRowMapper<ResultSet, ResultSet, T, SQLException>
    implements JdbcMapper<T> {
        public StaticJdbcSetRowMapper(Mapper<ResultSet, T> mapper, RowHandlerErrorHandler errorHandler, MappingContextFactory<? super ResultSet> mappingContextFactory) {
            super(mapper, errorHandler, mappingContextFactory, (UnaryFactory)new ResultSetEnumarableFactory());
        }
    }

    private static class ResultSetEnumarableFactory
    implements UnaryFactory<ResultSet, Enumarable<ResultSet>> {
        private ResultSetEnumarableFactory() {
        }

        @Override
        public Enumarable<ResultSet> newInstance(ResultSet rows) {
            return new ResultSetEnumarable(rows);
        }
    }

    public static class JoinDatastaxMapper<T>
    extends JoinMapperImpl<ResultSet, ResultSet, T, SQLException>
    implements JdbcMapper<T> {
        public JoinDatastaxMapper(Mapper<ResultSet, T> mapper, RowHandlerErrorHandler errorHandler, MappingContextFactory<? super ResultSet> mappingContextFactory) {
            super(mapper, errorHandler, mappingContextFactory, (UnaryFactory)new ResultSetEnumarableFactory());
        }

        @Override
        public MappingContext<? super ResultSet> newMappingContext(ResultSet rs) {
            return this.newMappingContext();
        }
    }
}

