/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.poi.impl;

import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.simpleflatmapper.map.ConsumerErrorHandler;
import org.simpleflatmapper.map.ContextualSourceFieldMapper;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.map.context.MappingContextFactory;
import org.simpleflatmapper.map.mapper.UnorderedJoinMapperEnumerable;
import org.simpleflatmapper.poi.RowMapper;
import org.simpleflatmapper.poi.impl.RowEnumerable;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.Enumerable;
import org.simpleflatmapper.util.EnumerableIterator;
import org.simpleflatmapper.util.EnumerableSpliterator;

public class UnorderedJoinSheetMapper<T>
implements RowMapper<T> {
    private final ContextualSourceFieldMapper<Row, T> mapper;
    private final int startRow = 0;
    private final ConsumerErrorHandler consumerErrorHandler;
    private final MappingContextFactory<? super Row> mappingContextFactory;

    public UnorderedJoinSheetMapper(ContextualSourceFieldMapper<Row, T> mapper, ConsumerErrorHandler consumerErrorHandler, MappingContextFactory<? super Row> mappingContextFactory) {
        this.mapper = mapper;
        this.consumerErrorHandler = consumerErrorHandler;
        this.mappingContextFactory = mappingContextFactory;
    }

    @Override
    public Iterator<T> iterator(Sheet sheet) {
        return this.iterator(0, sheet);
    }

    @Override
    public Iterator<T> iterator(int startRow, Sheet sheet) {
        return new EnumerableIterator(this.enumerable(startRow, sheet, this.newMappingContext()));
    }

    @Override
    public Enumerable<T> enumerate(Sheet sheet) {
        return this.enumerate(0, sheet);
    }

    @Override
    public Enumerable<T> enumerate(int startRow, Sheet sheet) {
        return this.enumerable(startRow, sheet, this.newMappingContext());
    }

    private Enumerable<T> enumerable(int startRow, Sheet sheet, MappingContext<? super Row> mappingContext) {
        return new UnorderedJoinMapperEnumerable(this.mapper, mappingContext, (Enumerable)new RowEnumerable(startRow, sheet));
    }

    @Override
    public <RH extends CheckedConsumer<? super T>> RH forEach(Sheet sheet, RH consumer) {
        return this.forEach(0, sheet, consumer);
    }

    @Override
    public <RH extends CheckedConsumer<? super T>> RH forEach(int startRow, Sheet sheet, RH consumer) {
        MappingContext<Row> mappingContext = this.newMappingContext();
        Enumerable<T> enumarable = this.enumerable(startRow, sheet, mappingContext);
        while (enumarable.next()) {
            try {
                consumer.accept(enumarable.currentValue());
            }
            catch (Exception e) {
                this.consumerErrorHandler.handlerError((Throwable)e, enumarable.currentValue());
            }
        }
        return consumer;
    }

    @Override
    public Stream<T> stream(Sheet sheet) {
        return this.stream(0, sheet);
    }

    @Override
    public Stream<T> stream(int startRow, Sheet sheet) {
        return StreamSupport.stream(new EnumerableSpliterator(this.enumerable(startRow, sheet, this.newMappingContext())), false);
    }

    public T map(Row source) throws MappingException {
        return (T)this.mapper.map((Object)source);
    }

    public T map(Row source, MappingContext<? super Row> context) throws MappingException {
        return (T)this.mapper.map((Object)source, context);
    }

    private MappingContext<? super Row> newMappingContext() {
        return this.mappingContextFactory.newContext();
    }
}

