/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import java.lang.reflect.Method;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.reflect.BiInstantiator;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.Function;

public final class GenericBuilder<S, T> {
    public static final Method BUILD;
    public final Object[] objects;
    public final BiInstantiator<Object[], Object, T> targetInstantiator;
    public final Setter<T, GenericBuilder<S, T>>[] targetFieldSetters;
    public final FieldMapper<S, GenericBuilder<S, T>>[] genericBuilderFieldMappers;

    public GenericBuilder(FieldMapper<S, GenericBuilder<S, T>>[] genericBuilderFieldMappers, BiInstantiator<Object[], Object, T> targetInstantiator, Setter<T, GenericBuilder<S, T>>[] targetFieldSetters) {
        this.objects = new Object[genericBuilderFieldMappers.length];
        this.genericBuilderFieldMappers = genericBuilderFieldMappers;
        this.targetInstantiator = targetInstantiator;
        this.targetFieldSetters = targetFieldSetters;
    }

    public T build() throws Exception {
        Object t = this.targetInstantiator.newInstance((Object)this.objects, (Object)this);
        for (Setter<T, GenericBuilder<S, T>> setter : this.targetFieldSetters) {
            setter.set(t, (Object)this);
        }
        return (T)t;
    }

    public void mapFrom(S source, MappingContext<? super S> context) throws Exception {
        for (FieldMapper<? super S, GenericBuilder<? super S, GenericBuilder>> fieldMapper : this.genericBuilderFieldMappers) {
            fieldMapper.mapTo((S)source, this, context);
        }
    }

    public static <S, T> Function<GenericBuilder<S, T>, T> buildFunction() {
        return new GenericBuilderTransformFunction();
    }

    static {
        try {
            BUILD = GenericBuilder.class.getMethod("build", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new Error("Unexpected error " + String.valueOf(e), e);
        }
    }

    private static class GenericBuilderTransformFunction<S, T>
    implements Function<GenericBuilder<S, T>, T> {
        private GenericBuilderTransformFunction() {
        }

        public T apply(GenericBuilder<S, T> o) {
            try {
                if (o == null) {
                    return null;
                }
                return o.build();
            }
            catch (Exception e) {
                return (T)ErrorHelper.rethrow((Throwable)e);
            }
        }
    }
}

