/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simpleflatmapper.map.ConsumerErrorHandler;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.FieldMapperErrorHandler;
import org.simpleflatmapper.map.MapperBuilderErrorHandler;
import org.simpleflatmapper.map.PropertyNameMatcherFactory;
import org.simpleflatmapper.map.error.RethrowConsumerErrorHandler;
import org.simpleflatmapper.map.error.RethrowFieldMapperErrorHandler;
import org.simpleflatmapper.map.error.RethrowMapperBuilderErrorHandler;
import org.simpleflatmapper.map.impl.IdentityFieldMapperColumnDefinitionProvider;
import org.simpleflatmapper.map.mapper.ColumnDefinitionProvider;
import org.simpleflatmapper.map.mapper.DefaultPropertyNameMatcherFactory;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.util.Asserts;
import org.simpleflatmapper.util.Enumerable;
import org.simpleflatmapper.util.Function;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.PredicatedEnumerable;
import org.simpleflatmapper.util.TypeHelper;
import org.simpleflatmapper.util.UnaryFactory;

public final class MapperConfig<K extends FieldKey<K>, S> {
    public static final int NO_ASM_MAPPER_THRESHOLD = 792;
    public static final int MAX_METHOD_SIZE = 128;
    private final ColumnDefinitionProvider<K> columnDefinitions;
    private final PropertyNameMatcherFactory propertyNameMatcherFactory;
    private final MapperBuilderErrorHandler mapperBuilderErrorHandler;
    private final boolean failOnAsm;
    private final int asmMapperNbFieldsLimit;
    private final FieldMapperErrorHandler<? super K> fieldMapperErrorHandler;
    private final ConsumerErrorHandler consumerErrorHandler;
    private final int maxMethodSize;
    private final boolean assumeInjectionModifiesValues;
    private final List<Discriminator<S, K, ?>> discriminators;
    private final Predicate<? super S> rowFilter;
    private final boolean unorderedJoin;

    public static <K extends FieldKey<K>, S> MapperConfig<K, S> fieldMapperConfig() {
        return new MapperConfig<Object, S>(new IdentityFieldMapperColumnDefinitionProvider(), DefaultPropertyNameMatcherFactory.DEFAULT, RethrowMapperBuilderErrorHandler.INSTANCE, false, 792, RethrowFieldMapperErrorHandler.INSTANCE, RethrowConsumerErrorHandler.INSTANCE, 128, false, Collections.emptyList(), null, false);
    }

    public static <K extends FieldKey<K>, S> MapperConfig<K, S> config(ColumnDefinitionProvider<K> columnDefinitionProvider) {
        return new MapperConfig<Object, S>(columnDefinitionProvider, DefaultPropertyNameMatcherFactory.DEFAULT, RethrowMapperBuilderErrorHandler.INSTANCE, false, 792, RethrowFieldMapperErrorHandler.INSTANCE, RethrowConsumerErrorHandler.INSTANCE, 128, false, Collections.emptyList(), null, false);
    }

    private MapperConfig(ColumnDefinitionProvider<K> columnDefinitions, PropertyNameMatcherFactory propertyNameMatcherFactory, MapperBuilderErrorHandler mapperBuilderErrorHandler, boolean failOnAsm, int asmMapperNbFieldsLimit, FieldMapperErrorHandler<? super K> fieldMapperErrorHandler, ConsumerErrorHandler consumerErrorHandler, int maxMethodSize, boolean assumeInjectionModifiesValues, List<Discriminator<S, K, ?>> discriminators, Predicate<? super S> rowFilter, boolean unorderedJoin) {
        this.columnDefinitions = columnDefinitions;
        this.propertyNameMatcherFactory = propertyNameMatcherFactory;
        this.mapperBuilderErrorHandler = mapperBuilderErrorHandler;
        this.failOnAsm = failOnAsm;
        this.asmMapperNbFieldsLimit = asmMapperNbFieldsLimit;
        this.fieldMapperErrorHandler = fieldMapperErrorHandler;
        this.consumerErrorHandler = consumerErrorHandler;
        this.maxMethodSize = maxMethodSize;
        this.assumeInjectionModifiesValues = assumeInjectionModifiesValues;
        this.discriminators = discriminators;
        this.rowFilter = rowFilter;
        this.unorderedJoin = unorderedJoin;
    }

    public ColumnDefinitionProvider<K> columnDefinitions() {
        return this.columnDefinitions;
    }

    public PropertyNameMatcherFactory propertyNameMatcherFactory() {
        return this.propertyNameMatcherFactory;
    }

    public MapperBuilderErrorHandler mapperBuilderErrorHandler() {
        return this.mapperBuilderErrorHandler;
    }

    public boolean failOnAsm() {
        return this.failOnAsm;
    }

    public boolean assumeInjectionModifiesValues() {
        return this.assumeInjectionModifiesValues;
    }

    public int asmMapperNbFieldsLimit() {
        return this.asmMapperNbFieldsLimit;
    }

    public MapperConfig<K, S> columnDefinitions(ColumnDefinitionProvider<K> columnDefinitions) {
        Asserts.requireNonNull((String)"columnDefinitions", columnDefinitions);
        return new MapperConfig<K, S>(columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, this.failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.consumerErrorHandler, this.maxMethodSize, this.assumeInjectionModifiesValues, this.discriminators, this.rowFilter, this.unorderedJoin);
    }

    public MapperConfig<K, S> propertyNameMatcherFactory(PropertyNameMatcherFactory propertyNameMatcherFactory) {
        return new MapperConfig<K, S>(this.columnDefinitions, (PropertyNameMatcherFactory)Asserts.requireNonNull((String)"propertyNameMatcherFactory", (Object)propertyNameMatcherFactory), this.mapperBuilderErrorHandler, this.failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.consumerErrorHandler, this.maxMethodSize, this.assumeInjectionModifiesValues, this.discriminators, this.rowFilter, this.unorderedJoin);
    }

    public MapperConfig<K, S> mapperBuilderErrorHandler(MapperBuilderErrorHandler mapperBuilderErrorHandler) {
        return new MapperConfig<K, S>(this.columnDefinitions, this.propertyNameMatcherFactory, (MapperBuilderErrorHandler)Asserts.requireNonNull((String)"mapperBuilderErrorHandler", (Object)mapperBuilderErrorHandler), this.failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.consumerErrorHandler, this.maxMethodSize, this.assumeInjectionModifiesValues, this.discriminators, this.rowFilter, this.unorderedJoin);
    }

    public MapperConfig<K, S> failOnAsm(boolean failOnAsm) {
        return new MapperConfig<K, S>(this.columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.consumerErrorHandler, this.maxMethodSize, this.assumeInjectionModifiesValues, this.discriminators, this.rowFilter, this.unorderedJoin);
    }

    public MapperConfig<K, S> assumeInjectionModifiesValues(boolean assumeInjectionModifiesValues) {
        return new MapperConfig<K, S>(this.columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, this.failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.consumerErrorHandler, this.maxMethodSize, assumeInjectionModifiesValues, this.discriminators, this.rowFilter, this.unorderedJoin);
    }

    public MapperConfig<K, S> asmMapperNbFieldsLimit(int asmMapperNbFieldsLimit) {
        return new MapperConfig<K, S>(this.columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, this.failOnAsm, asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.consumerErrorHandler, this.maxMethodSize, this.assumeInjectionModifiesValues, this.discriminators, this.rowFilter, this.unorderedJoin);
    }

    public MapperConfig<K, S> fieldMapperErrorHandler(FieldMapperErrorHandler<? super K> fieldMapperErrorHandler) {
        return new MapperConfig<K, S>(this.columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, this.failOnAsm, this.asmMapperNbFieldsLimit, fieldMapperErrorHandler, this.consumerErrorHandler, this.maxMethodSize, this.assumeInjectionModifiesValues, this.discriminators, this.rowFilter, this.unorderedJoin);
    }

    public MapperConfig<K, S> consumerErrorHandler(ConsumerErrorHandler consumerErrorHandler) {
        return new MapperConfig<K, S>(this.columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, this.failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, consumerErrorHandler, this.maxMethodSize, this.assumeInjectionModifiesValues, this.discriminators, this.rowFilter, this.unorderedJoin);
    }

    public MapperConfig<K, S> rowFilter(Predicate<? super S> rowFilter) {
        return new MapperConfig<K, S>(this.columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, this.failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.consumerErrorHandler, this.maxMethodSize, this.assumeInjectionModifiesValues, this.discriminators, rowFilter, this.unorderedJoin);
    }

    public MapperConfig<K, S> unorderedJoin(boolean unorderedJoin) {
        return new MapperConfig<K, S>(this.columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, this.failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.consumerErrorHandler, this.maxMethodSize, this.assumeInjectionModifiesValues, this.discriminators, this.rowFilter, unorderedJoin);
    }

    public boolean unorderedJoin() {
        return this.unorderedJoin;
    }

    public ConsumerErrorHandler consumerErrorHandler() {
        return this.consumerErrorHandler;
    }

    @Deprecated
    public MapperConfig<K, S> rowHandlerErrorHandler(ConsumerErrorHandler rowHandlerErrorHandler) {
        return this.consumerErrorHandler(rowHandlerErrorHandler);
    }

    public ConsumerErrorHandler rowHandlerErrorHandler() {
        return this.consumerErrorHandler();
    }

    public boolean hasFieldMapperErrorHandler() {
        return this.fieldMapperErrorHandler != null && !(this.fieldMapperErrorHandler instanceof RethrowFieldMapperErrorHandler);
    }

    public FieldMapperErrorHandler<? super K> fieldMapperErrorHandler() {
        return this.fieldMapperErrorHandler;
    }

    public int maxMethodSize() {
        return this.maxMethodSize;
    }

    public MapperConfig<K, S> maxMethodSize(int maxMethodSize) {
        return new MapperConfig<K, S>(this.columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, this.failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.consumerErrorHandler, maxMethodSize, this.assumeInjectionModifiesValues, this.discriminators, this.rowFilter, this.unorderedJoin);
    }

    @Deprecated
    public <T> MapperConfig<K, S> discriminator(Class<T> rootClass, Predicate<? super K> discriminatorPredicate, DiscriminatorCase<S, K, T> ... cases) {
        return this.discriminator((Type)rootClass, discriminatorPredicate, cases);
    }

    @Deprecated
    public <T> MapperConfig<K, S> discriminator(Type rootClass, Predicate<? super K> discriminatorPredicate, DiscriminatorCase<S, K, T> ... cases) {
        ArrayList discriminators = new ArrayList(this.discriminators);
        discriminators.add(new Discriminator<S, K, T>(rootClass, cases, discriminatorPredicate, null));
        return new MapperConfig<K, S>(this.columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, this.failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.consumerErrorHandler, this.maxMethodSize, this.assumeInjectionModifiesValues, discriminators, this.rowFilter, this.unorderedJoin);
    }

    public <S, T> Discriminator<S, K, T>[] getDiscriminators(ClassMeta<T> classMeta) {
        return this.getDiscriminators(classMeta.getType());
    }

    public <S, T> Discriminator<S, K, T>[] getDiscriminators(Type type) {
        ArrayList list = new ArrayList();
        for (Discriminator<S, K, ?> d : this.discriminators) {
            if (!TypeHelper.areEquals((Type)type, (Type)d.type)) continue;
            list.add(d);
        }
        return list.toArray(new Discriminator[0]);
    }

    public List<Discriminator<S, K, ?>> getDiscriminators() {
        return this.discriminators;
    }

    public MapperConfig<K, S> discriminators(List<Discriminator<S, K, ?>> discriminators) {
        return new MapperConfig<K, S>(this.columnDefinitions, this.propertyNameMatcherFactory, this.mapperBuilderErrorHandler, this.failOnAsm, this.asmMapperNbFieldsLimit, this.fieldMapperErrorHandler, this.consumerErrorHandler, this.maxMethodSize, this.assumeInjectionModifiesValues, discriminators, this.rowFilter, this.unorderedJoin);
    }

    public DiscriminatorCase<S, K, ?> getDiscriminatorCase(Type type) {
        return null;
    }

    public <SET> UnaryFactory<SET, Enumerable<S>> applyEnumerableFilter(final UnaryFactory<SET, Enumerable<S>> enumerableFactory) {
        final Predicate<? super S> rowFilter = this.rowFilter;
        if (rowFilter == null) {
            return enumerableFactory;
        }
        return new UnaryFactory<SET, Enumerable<S>>(){

            public Enumerable<S> newInstance(SET set) {
                Enumerable enumerable = (Enumerable)enumerableFactory.newInstance(set);
                return new PredicatedEnumerable(enumerable, rowFilter);
            }
        };
    }

    public static boolean sameDiscriminatorId(Object discriminatorId, Object discriminatorId1) {
        return discriminatorId == null || discriminatorId1 == null || discriminatorId == discriminatorId1;
    }

    public static final class Discriminator<ROW, K extends FieldKey<K>, T> {
        public final Type type;
        public final DiscriminatorCase<ROW, K, T>[] cases;
        public final Predicate<? super K> discriminatorPredicate;
        public final Object discriminatorId;

        public Discriminator(Type type, DiscriminatorCase<ROW, K, T>[] cases, Predicate<? super K> discriminatorPredicate, Object discriminatorId) {
            this.type = type;
            this.cases = cases;
            this.discriminatorPredicate = discriminatorPredicate;
            this.discriminatorId = discriminatorId;
        }

        public DiscriminatorCase<ROW, K, T> getCase(Type type) {
            for (DiscriminatorCase<ROW, K, T> c : this.cases) {
                if (!TypeHelper.areEquals((Type)type, (Type)c.classMeta.getType())) continue;
                return c;
            }
            throw new IllegalArgumentException("Not cases for type " + type);
        }

        public boolean isCompatibleWithKeys(List<K> allDiscriminatoryKeys) {
            if (this.discriminatorPredicate == null) {
                return true;
            }
            for (FieldKey k : allDiscriminatoryKeys) {
                if (this.discriminatorPredicate.test((Object)k)) continue;
                return false;
            }
            return !allDiscriminatoryKeys.isEmpty();
        }
    }

    public static final class DiscriminatorCase<ROW, K extends FieldKey<K>, T> {
        public final Function<List<K>, Predicate<ROW>> predicateFactory;
        public final ClassMeta<? extends T> classMeta;

        public DiscriminatorCase(Function<List<K>, Predicate<ROW>> predicateFactory, ClassMeta<? extends T> classMeta) {
            this.predicateFactory = predicateFactory;
            this.classMeta = classMeta;
        }
    }
}

