/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.getter;

import org.simpleflatmapper.converter.Context;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.getter.BooleanContextualGetter;
import org.simpleflatmapper.map.getter.ByteContextualGetter;
import org.simpleflatmapper.map.getter.CharacterContextualGetter;
import org.simpleflatmapper.map.getter.ContextualGetter;
import org.simpleflatmapper.map.getter.DoubleContextualGetter;
import org.simpleflatmapper.map.getter.FloatContextualGetter;
import org.simpleflatmapper.map.getter.IntContextualGetter;
import org.simpleflatmapper.map.getter.LongContextualGetter;
import org.simpleflatmapper.map.getter.ShortContextualGetter;
import org.simpleflatmapper.util.BiFunction;
import org.simpleflatmapper.util.ErrorHelper;

public class ContextualGetterBiFunction<S, T>
implements BiFunction<S, Context, T> {
    private final ContextualGetter<? super S, ? extends T> fieldMapperGetter;

    public ContextualGetterBiFunction(ContextualGetter<? super S, ? extends T> fieldMapperGetter) {
        this.fieldMapperGetter = fieldMapperGetter;
    }

    public static <S, T> BiFunction<? super S, ? super MappingContext<?>, T> of(Class<?> type, ContextualGetter<? super S, ? extends T> getter) {
        if (type.isPrimitive()) {
            if (Boolean.TYPE.equals(type) && getter instanceof BooleanContextualGetter) {
                BooleanContextualGetter pGetter = (BooleanContextualGetter)((Object)getter);
                return new BooleanBiFunction(pGetter);
            }
            if (Byte.TYPE.equals(type) && getter instanceof ByteContextualGetter) {
                ByteContextualGetter pGetter = (ByteContextualGetter)((Object)getter);
                return new ByteBiFunction(pGetter);
            }
            if (Character.TYPE.equals(type) && getter instanceof CharacterContextualGetter) {
                CharacterContextualGetter pGetter = (CharacterContextualGetter)((Object)getter);
                return new CharacterBiFunction(pGetter);
            }
            if (Short.TYPE.equals(type) && getter instanceof ShortContextualGetter) {
                ShortContextualGetter pGetter = (ShortContextualGetter)((Object)getter);
                return new ShortBiFunction(pGetter);
            }
            if (Integer.TYPE.equals(type) && getter instanceof IntContextualGetter) {
                IntContextualGetter pGetter = (IntContextualGetter)((Object)getter);
                return new IntegerBiFunction(pGetter);
            }
            if (Long.TYPE.equals(type) && getter instanceof LongContextualGetter) {
                LongContextualGetter pGetter = (LongContextualGetter)((Object)getter);
                return new LongBiFunction(pGetter);
            }
            if (Float.TYPE.equals(type) && getter instanceof FloatContextualGetter) {
                FloatContextualGetter pGetter = (FloatContextualGetter)((Object)getter);
                return new FloatBiFunction(pGetter);
            }
            if (Double.TYPE.equals(type) && getter instanceof DoubleContextualGetter) {
                DoubleContextualGetter pGetter = (DoubleContextualGetter)((Object)getter);
                return new DoubleBiFunction(pGetter);
            }
        }
        return new ContextualGetterBiFunction<S, T>(getter);
    }

    public T apply(S s, Context mappingContext) {
        try {
            return this.fieldMapperGetter.get(s, mappingContext);
        }
        catch (Exception e) {
            return (T)ErrorHelper.rethrow((Throwable)e);
        }
    }

    public static final class DoubleBiFunction<S>
    implements BiFunction<S, MappingContext<?>, Double> {
        private final DoubleContextualGetter pGetter;

        public DoubleBiFunction(DoubleContextualGetter pGetter) {
            this.pGetter = pGetter;
        }

        public Double apply(S s, MappingContext<?> mappingContext) {
            try {
                return this.pGetter.getDouble(s, mappingContext);
            }
            catch (Exception e) {
                return (Double)ErrorHelper.rethrow((Throwable)e);
            }
        }
    }

    public static final class FloatBiFunction<S>
    implements BiFunction<S, MappingContext<?>, Float> {
        private final FloatContextualGetter pGetter;

        public FloatBiFunction(FloatContextualGetter pGetter) {
            this.pGetter = pGetter;
        }

        public Float apply(S s, MappingContext<?> mappingContext) {
            try {
                return Float.valueOf(this.pGetter.getFloat(s, mappingContext));
            }
            catch (Exception e) {
                return (Float)ErrorHelper.rethrow((Throwable)e);
            }
        }
    }

    public static final class LongBiFunction<S>
    implements BiFunction<S, MappingContext<?>, Long> {
        private final LongContextualGetter pGetter;

        public LongBiFunction(LongContextualGetter pGetter) {
            this.pGetter = pGetter;
        }

        public Long apply(S s, MappingContext<?> mappingContext) {
            try {
                return this.pGetter.getLong(s, mappingContext);
            }
            catch (Exception e) {
                return (Long)ErrorHelper.rethrow((Throwable)e);
            }
        }
    }

    public static final class IntegerBiFunction<S>
    implements BiFunction<S, MappingContext<?>, Integer> {
        private final IntContextualGetter pGetter;

        public IntegerBiFunction(IntContextualGetter pGetter) {
            this.pGetter = pGetter;
        }

        public Integer apply(S s, MappingContext<?> mappingContext) {
            try {
                return this.pGetter.getInt(s, mappingContext);
            }
            catch (Exception e) {
                return (Integer)ErrorHelper.rethrow((Throwable)e);
            }
        }
    }

    public static final class ShortBiFunction<S>
    implements BiFunction<S, MappingContext<?>, Short> {
        private final ShortContextualGetter pGetter;

        public ShortBiFunction(ShortContextualGetter pGetter) {
            this.pGetter = pGetter;
        }

        public Short apply(S s, MappingContext<?> mappingContext) {
            try {
                return this.pGetter.getShort(s, mappingContext);
            }
            catch (Exception e) {
                return (Short)ErrorHelper.rethrow((Throwable)e);
            }
        }
    }

    public static final class CharacterBiFunction<S>
    implements BiFunction<S, MappingContext<?>, Character> {
        private final CharacterContextualGetter pGetter;

        public CharacterBiFunction(CharacterContextualGetter pGetter) {
            this.pGetter = pGetter;
        }

        public Character apply(S s, MappingContext<?> mappingContext) {
            try {
                return Character.valueOf(this.pGetter.getCharacter(s, mappingContext));
            }
            catch (Exception e) {
                return (Character)ErrorHelper.rethrow((Throwable)e);
            }
        }
    }

    public static final class ByteBiFunction<S>
    implements BiFunction<S, MappingContext<?>, Byte> {
        private final ByteContextualGetter pGetter;

        public ByteBiFunction(ByteContextualGetter pGetter) {
            this.pGetter = pGetter;
        }

        public Byte apply(S s, MappingContext<?> mappingContext) {
            try {
                return this.pGetter.getByte(s, mappingContext);
            }
            catch (Exception e) {
                return (Byte)ErrorHelper.rethrow((Throwable)e);
            }
        }
    }

    public static final class BooleanBiFunction<S>
    implements BiFunction<S, MappingContext<?>, Boolean> {
        private final BooleanContextualGetter pGetter;

        public BooleanBiFunction(BooleanContextualGetter pGetter) {
            this.pGetter = pGetter;
        }

        public Boolean apply(S s, MappingContext<?> mappingContext) {
            try {
                return this.pGetter.getBoolean(s, mappingContext);
            }
            catch (Exception e) {
                return (Boolean)ErrorHelper.rethrow((Throwable)e);
            }
        }
    }
}

