/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.context.impl;

import java.util.List;
import org.simpleflatmapper.map.context.KeyAndPredicate;
import org.simpleflatmapper.map.context.KeySourceGetter;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.Predicate;

public class NullChecker<S, K>
implements Predicate<S> {
    private final List<KeyAndPredicate<S, K>> keys;
    private final KeySourceGetter<K, ? super S> keySourceGetter;

    public NullChecker(List<KeyAndPredicate<S, K>> keys, KeySourceGetter<K, ? super S> keySourceGetter) {
        this.keys = keys;
        this.keySourceGetter = keySourceGetter;
    }

    public boolean test(S s) {
        try {
            boolean empty = true;
            for (KeyAndPredicate<S, K> keyAndPredicate : this.keys) {
                if (!keyAndPredicate.test(s)) continue;
                empty = false;
                if (this.keySourceGetter.getValue(keyAndPredicate.key, s) == null) continue;
                return false;
            }
            return !empty;
        }
        catch (Exception e) {
            ErrorHelper.rethrow((Throwable)e);
            throw new IllegalStateException();
        }
    }
}

