/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.impl;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMatchingScore;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;
import org.simpleflatmapper.util.BiConsumer;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeHelper;

public class DiscriminatorPropertyFinder<T>
extends PropertyFinder<T> {
    private final Map<PropertyMeta<?, ?>, PropertyFinder<?>> subPropertyFinders = new HashMap();
    private final Type ownerType;
    private final List<PropertyFinder<? extends T>> implementationPropertyFinders;
    private final ReflectionService reflectionService;

    protected DiscriminatorPropertyFinder(Predicate<PropertyMeta<?, ?>> propertyFilter, boolean selfScoreFullName, Type ownerType, List<ClassMeta<?>> implemetations, ReflectionService reflectionService) {
        super(propertyFilter, selfScoreFullName);
        this.ownerType = ownerType;
        this.reflectionService = reflectionService;
        this.implementationPropertyFinders = new ArrayList<PropertyFinder<? extends T>>();
        for (ClassMeta<?> cm : implemetations) {
            this.implementationPropertyFinders.add(cm.newPropertyFinder(propertyFilter));
        }
    }

    public void lookForProperties(PropertyNameMatcher propertyNameMatcher, Object[] properties, PropertyFinder.FoundProperty<T> matchingProperties, PropertyMatchingScore score, boolean allowSelfReference, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer, PropertyFinder.TypeAffinityScorer typeAffinityScorer) {
        final ArrayList<DiscriminatorMatch> matches = new ArrayList<DiscriminatorMatch>();
        PropertyMatchingScore bestScore = null;
        for (PropertyFinder<? extends T> propertyFinder : this.implementationPropertyFinders) {
            final ArrayList matchedProperties = new ArrayList();
            propertyFinder.lookForProperties(propertyNameMatcher, properties, new PropertyFinder.FoundProperty(){

                public void found(PropertyMeta propertyMeta, Runnable selectionCallback, PropertyMatchingScore score, PropertyFinder.TypeAffinityScorer typeAffinityScorer) {
                    matchedProperties.add(new PropertyFinder.MatchedProperty(propertyMeta, selectionCallback, score, typeAffinityScorer.score(propertyMeta.getPropertyType())));
                }
            }, score, false, propertyFinderTransformer, typeAffinityScorer);
            if (matchedProperties.isEmpty()) continue;
            Collections.sort(matchedProperties);
            PropertyFinder.MatchedProperty selectedMatchedProperty = (PropertyFinder.MatchedProperty)matchedProperties.get(0);
            matches.add(new DiscriminatorMatch(propertyFinder.getOwnerType(), selectedMatchedProperty));
            if (bestScore != null && bestScore.compareTo(selectedMatchedProperty.getScore()) <= 0) continue;
            bestScore = selectedMatchedProperty.getScore();
        }
        if (!matches.isEmpty()) {
            DiscriminatorPropertyMeta discriminatorPropertyMeta = new DiscriminatorPropertyMeta("unknown", this.ownerType, this.reflectionService, matches);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    for (DiscriminatorMatch dm : matches) {
                        dm.matchedProperty.select();
                    }
                }
            };
            matchingProperties.found(discriminatorPropertyMeta, runnable, bestScore, typeAffinityScorer);
        }
    }

    public <T> PropertyFinder<T> getImplementationPropertyFinder(Type implementationType) {
        for (PropertyFinder<? extends T> propertyFinder : this.implementationPropertyFinders) {
            if (!TypeHelper.areEquals((Type)propertyFinder.getOwnerType(), (Type)implementationType)) continue;
            return propertyFinder;
        }
        throw new IllegalArgumentException("Could not find implementation propertyfinder for " + implementationType);
    }

    public List<InstantiatorDefinition> getEligibleInstantiatorDefinitions() {
        return null;
    }

    public PropertyFinder<?> getSubPropertyFinder(PropertyMeta<?, ?> owner) {
        return this.subPropertyFinders.get(owner);
    }

    public PropertyFinder<?> getOrCreateSubPropertyFinder(SubPropertyMeta<?, ?, ?> subPropertyMeta) {
        PropertyFinder propertyFinder = this.subPropertyFinders.get(subPropertyMeta.getOwnerProperty());
        if (propertyFinder == null) {
            propertyFinder = subPropertyMeta.getSubProperty().getPropertyClassMeta().newPropertyFinder(this.propertyFilter);
            this.subPropertyFinders.put(subPropertyMeta.getOwnerProperty(), propertyFinder);
        }
        return propertyFinder;
    }

    public void manualMatch(PropertyMeta<?, ?> prop) {
        if (!(prop instanceof DiscriminatorPropertyMeta)) {
            super.manualMatch(prop);
        }
        DiscriminatorPropertyMeta dpm = (DiscriminatorPropertyMeta)prop;
        dpm.forEachProperty(new BiConsumer<Type, PropertyMeta<?, ?>>(){

            public void accept(Type type, PropertyMeta<?, ?> propertyMeta) {
                PropertyFinder pf = DiscriminatorPropertyFinder.this.getImplementationPropertyFinder(type);
                pf.manualMatch(propertyMeta);
            }
        });
    }

    public Type getOwnerType() {
        return this.ownerType;
    }

    public static class DiscriminatorPropertyMeta<O, P>
    extends PropertyMeta<O, P> {
        private final List<DiscriminatorMatch> matches;

        public DiscriminatorPropertyMeta(String name, Type ownerType, ReflectionService reflectService, List<DiscriminatorMatch> matches) {
            super(name, ownerType, reflectService);
            this.matches = matches;
        }

        public <C extends BiConsumer<Type, PropertyMeta<?, ?>>> C forEachProperty(C consumer) {
            for (DiscriminatorMatch dm : this.matches) {
                consumer.accept((Object)dm.type, (Object)dm.matchedProperty.getPropertyMeta());
            }
            return consumer;
        }

        public Setter<? super O, ? super P> getSetter() {
            throw new UnsupportedOperationException();
        }

        public Getter<? super O, ? extends P> getGetter() {
            throw new UnsupportedOperationException();
        }

        public boolean isConstructorProperty() {
            throw new UnsupportedOperationException();
        }

        public boolean isSubProperty() {
            throw new UnsupportedOperationException();
        }

        public Type getPropertyType() {
            throw new UnsupportedOperationException();
        }

        public String getPath() {
            return this.matches.get(0).matchedProperty.getPropertyMeta().getPath();
        }

        public PropertyMeta<O, P> withReflectionService(ReflectionService reflectionService) {
            throw new UnsupportedOperationException();
        }

        public int typeAffinityScore(PropertyFinder.TypeAffinityScorer typeAffinityScorer) {
            int bestScore = -1;
            for (DiscriminatorMatch dm : this.matches) {
                bestScore = Math.max(bestScore, dm.matchedProperty.getPropertyMeta().typeAffinityScore(typeAffinityScorer));
            }
            return bestScore;
        }
    }

    private static class DiscriminatorMatch {
        private final Type type;
        private final PropertyFinder.MatchedProperty<?, ?> matchedProperty;

        private DiscriminatorMatch(Type type, PropertyFinder.MatchedProperty<?, ?> matchedProperty) {
            this.type = type;
            this.matchedProperty = matchedProperty;
        }
    }
}

