/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.simpleflatmapper.map.ConsumerErrorHandler;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.FieldMapperErrorHandler;
import org.simpleflatmapper.map.IgnoreMapperBuilderErrorHandler;
import org.simpleflatmapper.map.MapperBuilderErrorHandler;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.PropertyNameMatcherFactory;
import org.simpleflatmapper.map.error.RethrowConsumerErrorHandler;
import org.simpleflatmapper.map.error.RethrowMapperBuilderErrorHandler;
import org.simpleflatmapper.map.mapper.AbstractColumnDefinitionProvider;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.ColumnDefinitionProvider;
import org.simpleflatmapper.map.mapper.DefaultPropertyNameMatcherFactory;
import org.simpleflatmapper.map.property.OptionalProperty;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.util.CheckedBiFunction;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.EqualsPredicate;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeHelper;
import org.simpleflatmapper.util.TypeReference;
import org.simpleflatmapper.util.UnaryFactory;

public abstract class AbstractMapperFactory<K extends FieldKey<K>, MF extends AbstractMapperFactory<K, MF, S>, S> {
    private FieldMapperErrorHandler<K> fieldMapperErrorHandler = null;
    private MapperBuilderErrorHandler mapperBuilderErrorHandler = RethrowMapperBuilderErrorHandler.INSTANCE;
    private ConsumerErrorHandler consumerErrorHandler = RethrowConsumerErrorHandler.INSTANCE;
    private final AbstractColumnDefinitionProvider<K> columnDefinitions;
    private final List<MapperConfig.Discriminator<S, ?>> discriminators = new ArrayList();
    private final ColumnDefinition<K, ?> identity;
    private boolean useAsm = true;
    private boolean failOnAsm = false;
    private int asmMapperNbFieldsLimit = 792;
    private PropertyNameMatcherFactory propertyNameMatcherFactory = DefaultPropertyNameMatcherFactory.DEFAULT;
    private ReflectionService reflectionService = null;
    private int maxMethodSize = 128;
    private boolean assumeInjectionModifiesValues;
    private Predicate<? super S> rowFilter = null;

    public AbstractMapperFactory(AbstractMapperFactory<K, ?, S> config) {
        this.fieldMapperErrorHandler = config.fieldMapperErrorHandler;
        this.mapperBuilderErrorHandler = config.mapperBuilderErrorHandler;
        this.consumerErrorHandler = config.consumerErrorHandler;
        this.columnDefinitions = config.columnDefinitions;
        this.identity = config.identity;
        this.useAsm = config.useAsm;
        this.failOnAsm = config.failOnAsm;
        this.asmMapperNbFieldsLimit = config.asmMapperNbFieldsLimit;
        this.propertyNameMatcherFactory = config.propertyNameMatcherFactory;
        this.reflectionService = config.reflectionService;
        this.maxMethodSize = config.maxMethodSize;
        this.assumeInjectionModifiesValues = config.assumeInjectionModifiesValues;
        this.rowFilter = config.rowFilter;
    }

    public AbstractMapperFactory(AbstractColumnDefinitionProvider<K> columnDefinitions, ColumnDefinition<K, ?> identity) {
        this.columnDefinitions = columnDefinitions;
        this.identity = identity;
    }

    public final MF fieldMapperErrorHandler(FieldMapperErrorHandler<K> fieldMapperErrorHandler) {
        this.fieldMapperErrorHandler = fieldMapperErrorHandler;
        return (MF)this;
    }

    public final MF ignorePropertyNotFound() {
        return this.mapperBuilderErrorHandler(IgnoreMapperBuilderErrorHandler.INSTANCE);
    }

    public final MF mapperBuilderErrorHandler(MapperBuilderErrorHandler mapperBuilderErrorHandler) {
        this.mapperBuilderErrorHandler = mapperBuilderErrorHandler;
        return (MF)this;
    }

    public final MF consumerErrorHandler(ConsumerErrorHandler consumerErrorHandler) {
        this.consumerErrorHandler = consumerErrorHandler;
        return (MF)this;
    }

    @Deprecated
    public final MF rowHandlerErrorHandler(ConsumerErrorHandler rowHandlerErrorHandler) {
        return this.consumerErrorHandler(rowHandlerErrorHandler);
    }

    public final MF useAsm(boolean useAsm) {
        if (this.reflectionService != null) {
            throw new IllegalStateException("Reflection service is set cannot change useAsm");
        }
        this.useAsm = useAsm;
        return (MF)this;
    }

    public final MF reflectionService(ReflectionService reflectionService) {
        this.reflectionService = reflectionService;
        return (MF)this;
    }

    public final MF rowFilter(Predicate<? super S> rowFilter) {
        this.rowFilter = rowFilter;
        return (MF)this;
    }

    public final MapperConfig<K, S> mapperConfig() {
        return MapperConfig.config(this.enrichColumnDefinitions(this.columnDefinitions)).mapperBuilderErrorHandler(this.mapperBuilderErrorHandler).propertyNameMatcherFactory(this.propertyNameMatcherFactory).failOnAsm(this.failOnAsm).asmMapperNbFieldsLimit(this.asmMapperNbFieldsLimit).fieldMapperErrorHandler(this.fieldMapperErrorHandler).consumerErrorHandler(this.consumerErrorHandler).maxMethodSize(this.maxMethodSize).assumeInjectionModifiesValues(this.assumeInjectionModifiesValues).discriminators(this.discriminators).rowFilter(this.rowFilter);
    }

    public AbstractColumnDefinitionProvider<K> enrichColumnDefinitions(AbstractColumnDefinitionProvider<K> columnDefinitions) {
        return columnDefinitions;
    }

    public final MF addAlias(String column, String actualPropertyName) {
        return this.addColumnDefinition(column, (ColumnDefinition<K, ?>)this.identity.addRename(actualPropertyName));
    }

    public final MF addColumnDefinition(String column, ColumnDefinition<K, ?> columnDefinition) {
        this.columnDefinitions.addColumnDefinition(column, columnDefinition);
        return (MF)this;
    }

    public final MF addColumnDefinition(Predicate<? super K> predicate, ColumnDefinition<K, ?> columnDefinition) {
        this.columnDefinitions.addColumnDefinition(predicate, columnDefinition);
        return (MF)this;
    }

    public final MF addColumnProperty(String column, Object ... properties) {
        for (Object property : properties) {
            this.columnDefinitions.addColumnProperty(column, property);
        }
        return (MF)this;
    }

    public final MF addColumnProperty(Predicate<? super K> predicate, Object ... properties) {
        for (Object property : properties) {
            this.columnDefinitions.addColumnProperty(predicate, property);
        }
        return (MF)this;
    }

    public final MF addColumnProperty(Predicate<? super K> predicate, UnaryFactory<K, Object> propertyFactory) {
        this.columnDefinitions.addColumnProperty(predicate, propertyFactory);
        return (MF)this;
    }

    public final MF propertyNameMatcherFactory(PropertyNameMatcherFactory propertyNameMatcherFactory) {
        this.propertyNameMatcherFactory = propertyNameMatcherFactory;
        return (MF)this;
    }

    public final MF addAliases(Map<String, String> aliases) {
        for (Map.Entry<String, String> e : aliases.entrySet()) {
            this.addAlias(e.getKey(), e.getValue());
        }
        return (MF)this;
    }

    public final MF failOnAsm(boolean b) {
        this.failOnAsm = b;
        return (MF)this;
    }

    public final MF assumeInjectionModifiesValues(boolean b) {
        this.assumeInjectionModifiesValues = b;
        return (MF)this;
    }

    public final MF asmMapperNbFieldsLimit(int asmMapperNbFieldsLimit) {
        this.asmMapperNbFieldsLimit = asmMapperNbFieldsLimit;
        return (MF)this;
    }

    public final MF maxMethodSize(int maxMethodSize) {
        this.maxMethodSize = maxMethodSize;
        return (MF)this;
    }

    public final MF addKeys(String ... columns) {
        for (String col : columns) {
            this.addColumnDefinition(col, (ColumnDefinition<K, ?>)this.identity.addKey());
        }
        return (MF)this;
    }

    public final ConsumerErrorHandler consumerErrorHandler() {
        return this.consumerErrorHandler;
    }

    public final <T> ClassMeta<T> getClassMeta(TypeReference<T> target) {
        return this.getClassMeta(target.getType());
    }

    public final <T> ClassMeta<T> getClassMeta(Class<T> target) {
        return this.getClassMeta((Type)target);
    }

    public final <T> ClassMeta<T> getClassMeta(Type target) {
        return this.getReflectionService().getClassMeta(target);
    }

    public final <T> ClassMeta<T> getClassMetaWithExtraInstantiator(TypeReference<T> target, Member instantiator) {
        return this.getClassMetaWithExtraInstantiator(target.getType(), instantiator);
    }

    public final <T> ClassMeta<T> getClassMetaWithExtraInstantiator(Class<T> target, Member instantiator) {
        return this.getClassMetaWithExtraInstantiator((Type)target, instantiator);
    }

    public final <T> ClassMeta<T> getClassMetaWithExtraInstantiator(Type target, Member instantiator) {
        return this.getReflectionService().getClassMetaExtraInstantiator(target, instantiator);
    }

    public ReflectionService getReflectionService() {
        if (this.reflectionService == null) {
            this.reflectionService = ReflectionService.newInstance((boolean)this.useAsm);
        }
        return this.reflectionService;
    }

    public ColumnDefinitionProvider<K> columnDefinitions() {
        return this.columnDefinitions;
    }

    public <T> MF discriminator(Type commonType, Consumer<DiscriminatorBuilder<S, T>> consumer) {
        DiscriminatorBuilder db = new DiscriminatorBuilder(commonType, this.getReflectionService());
        consumer.accept(db);
        this.discriminators.add(new MapperConfig.Discriminator(commonType, db.cases.toArray(new MapperConfig.DiscriminatorCase[0])));
        return (MF)this;
    }

    public <T, V> MF discriminator(Type commonType, Getter<? super S, ? extends V> getter, Consumer<DiscriminatorConditionBuilder<S, V, T>> consumer) {
        DiscriminatorBuilder db = new DiscriminatorBuilder(commonType, this.getReflectionService());
        DiscriminatorConditionBuilder dcb = new DiscriminatorConditionBuilder(db, getter);
        consumer.accept(dcb);
        this.discriminators.add(new MapperConfig.Discriminator(commonType, db.cases.toArray(new MapperConfig.DiscriminatorCase[0])));
        return (MF)this;
    }

    public <T> MF discriminator(Class<T> commonType, Consumer<DiscriminatorBuilder<S, T>> consumer) {
        return this.discriminator((Type)commonType, consumer);
    }

    public <T, V> MF discriminator(Class<T> commonType, Getter<? super S, ? extends V> getter, Consumer<DiscriminatorConditionBuilder<S, V, T>> consumer) {
        return this.discriminator((Type)commonType, getter, consumer);
    }

    public <T, V> MF discriminator(Class<T> commonType, String discriminatorColumn, CheckedBiFunction<S, String, V> discriminatorFieldAccessor, Consumer<DiscriminatorConditionBuilder<S, V, T>> consumer) {
        return this.discriminator((Type)commonType, discriminatorColumn, discriminatorFieldAccessor, consumer);
    }

    public <T, V> MF discriminator(Type commonType, final String discriminatorColumn, final CheckedBiFunction<S, String, V> discriminatorFieldAccessor, Consumer<DiscriminatorConditionBuilder<S, V, T>> consumer) {
        this.addColumnProperty(discriminatorColumn, OptionalProperty.INSTANCE);
        Getter getter = new Getter<S, V>(){

            public V get(S target) throws Exception {
                return discriminatorFieldAccessor.apply(target, (Object)discriminatorColumn);
            }
        };
        return this.discriminator(commonType, getter, consumer);
    }

    public static final class DiscriminatorBuilder<S, T> {
        private final Type commonType;
        private final ReflectionService reflectionService;
        List<MapperConfig.DiscriminatorCase<S, T>> cases = new ArrayList<MapperConfig.DiscriminatorCase<S, T>>();

        public DiscriminatorBuilder(Type type, ReflectionService reflectionService) {
            this.commonType = type;
            this.reflectionService = reflectionService;
        }

        public DiscriminatorBuilder<S, T> when(Predicate<S> predicate, ClassMeta<? extends T> classMeta) {
            return this.discriminatorCase(predicate, classMeta);
        }

        public DiscriminatorBuilder<S, T> when(Predicate<S> predicate, Class<? extends T> target) {
            return this.discriminatorCase(predicate, target);
        }

        public DiscriminatorBuilder<S, T> when(Predicate<S> predicate, Type target) {
            return this.discriminatorCase(predicate, target);
        }

        public DiscriminatorBuilder<S, T> discriminatorCase(Predicate<S> predicate, ClassMeta<? extends T> classMeta) {
            MapperConfig.DiscriminatorCase<S, ? extends T> dCase = new MapperConfig.DiscriminatorCase<S, T>(predicate, classMeta);
            this.cases.add(dCase);
            return this;
        }

        public DiscriminatorBuilder<S, T> discriminatorCase(Predicate<S> predicate, Class<? extends T> target) {
            return this.discriminatorCase(predicate, this.reflectionService.getClassMeta(target));
        }

        public DiscriminatorBuilder<S, T> discriminatorCase(Predicate<S> predicate, Type target) {
            if (!TypeHelper.isAssignable((Type)this.commonType, (Type)target)) {
                throw new IllegalArgumentException("type " + target + " is not a subclass of " + this.commonType);
            }
            return this.discriminatorCase(predicate, this.reflectionService.getClassMeta(target));
        }
    }

    public static class DiscriminatorConditionBuilder<S, V, T> {
        private final DiscriminatorBuilder<S, T> discriminatorBuilder;
        private final Getter<? super S, ? extends V> getter;

        public DiscriminatorConditionBuilder(DiscriminatorBuilder<S, T> discriminatorBuilder, Getter<? super S, ? extends V> getter) {
            this.discriminatorBuilder = discriminatorBuilder;
            this.getter = getter;
        }

        public DiscriminatorConditionBuilder<S, V, T> when(V value, Type type) {
            return this.discriminatorCase(value, type);
        }

        public DiscriminatorConditionBuilder<S, V, T> when(V value, Class<T> type) {
            return this.discriminatorCase(value, type);
        }

        public DiscriminatorConditionBuilder<S, V, T> when(V value, ClassMeta<? extends T> classMeta) {
            return this.discriminatorCase(value, classMeta);
        }

        public DiscriminatorConditionBuilder<S, V, T> when(Predicate<V> predicate, Type type) {
            return this.discriminatorCase(predicate, type);
        }

        public DiscriminatorConditionBuilder<S, V, T> when(Predicate<V> predicate, Class<T> type) {
            return this.discriminatorCase(predicate, type);
        }

        public DiscriminatorConditionBuilder<S, V, T> when(Predicate<V> predicate, ClassMeta<? extends T> classMeta) {
            return this.discriminatorCase(predicate, classMeta);
        }

        public DiscriminatorConditionBuilder<S, V, T> discriminatorCase(V value, Type type) {
            return this.discriminatorCase(this.toEqualsPredicate(value), type);
        }

        public DiscriminatorConditionBuilder<S, V, T> discriminatorCase(V value, Class<T> type) {
            return this.discriminatorCase(this.toEqualsPredicate(value), type);
        }

        public DiscriminatorConditionBuilder<S, V, T> discriminatorCase(V value, ClassMeta<? extends T> classMeta) {
            return this.discriminatorCase(this.toEqualsPredicate(value), classMeta);
        }

        public DiscriminatorConditionBuilder<S, V, T> discriminatorCase(Predicate<V> predicate, Type type) {
            this.discriminatorBuilder.when(this.toSourcePredicate(predicate), type);
            return this;
        }

        public DiscriminatorConditionBuilder<S, V, T> discriminatorCase(Predicate<V> predicate, Class<T> type) {
            this.discriminatorBuilder.when(this.toSourcePredicate(predicate), type);
            return this;
        }

        public DiscriminatorConditionBuilder<S, V, T> discriminatorCase(Predicate<V> predicate, ClassMeta<? extends T> classMeta) {
            this.discriminatorBuilder.when(this.toSourcePredicate(predicate), classMeta);
            return this;
        }

        private Predicate<V> toEqualsPredicate(V value) {
            return EqualsPredicate.of(value);
        }

        private Predicate<S> toSourcePredicate(Predicate<V> predicate) {
            return new SourcePredicate<S, V>(predicate, this.getter);
        }

        static class SourcePredicate<S, V>
        implements Predicate<S> {
            final Predicate<? super V> predicate;
            final Getter<? super S, ? extends V> getter;

            public SourcePredicate(Predicate<? super V> predicate, Getter<? super S, ? extends V> getter) {
                this.predicate = predicate;
                this.getter = getter;
            }

            public boolean test(S s) {
                try {
                    return this.predicate.test(this.getter.get(s));
                }
                catch (Exception e) {
                    return (Boolean)ErrorHelper.rethrow((Throwable)e);
                }
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                SourcePredicate that = (SourcePredicate)o;
                if (this.predicate != null ? !this.predicate.equals(that.predicate) : that.predicate != null) {
                    return false;
                }
                return this.getter != null ? this.getter.equals(that.getter) : that.getter == null;
            }

            public int hashCode() {
                int result = this.predicate != null ? this.predicate.hashCode() : 0;
                result = 31 * result + (this.getter != null ? this.getter.hashCode() : 0);
                return result;
            }
        }
    }
}

