/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Map;
import org.simpleflatmapper.map.ConsumerErrorHandler;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.FieldMapperErrorHandler;
import org.simpleflatmapper.map.IgnoreMapperBuilderErrorHandler;
import org.simpleflatmapper.map.MapperBuilderErrorHandler;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.PropertyNameMatcherFactory;
import org.simpleflatmapper.map.error.RethrowConsumerErrorHandler;
import org.simpleflatmapper.map.error.RethrowMapperBuilderErrorHandler;
import org.simpleflatmapper.map.mapper.AbstractColumnDefinitionProvider;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.ColumnDefinitionProvider;
import org.simpleflatmapper.map.mapper.DefaultPropertyNameMatcherFactory;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeReference;
import org.simpleflatmapper.util.UnaryFactory;

public abstract class AbstractMapperFactory<K extends FieldKey<K>, MF extends AbstractMapperFactory<K, MF>> {
    private FieldMapperErrorHandler<K> fieldMapperErrorHandler = null;
    private MapperBuilderErrorHandler mapperBuilderErrorHandler = RethrowMapperBuilderErrorHandler.INSTANCE;
    private ConsumerErrorHandler consumerErrorHandler = RethrowConsumerErrorHandler.INSTANCE;
    private final AbstractColumnDefinitionProvider<K> columnDefinitions;
    private final ColumnDefinition<K, ?> identity;
    private boolean useAsm = true;
    private boolean failOnAsm = false;
    private int asmMapperNbFieldsLimit = 792;
    private PropertyNameMatcherFactory propertyNameMatcherFactory = DefaultPropertyNameMatcherFactory.DEFAULT;
    private ReflectionService reflectionService = null;
    private int maxMethodSize = 128;
    private boolean assumeInjectionModifiesValues;

    public AbstractMapperFactory(AbstractMapperFactory<K, ?> config) {
        this.fieldMapperErrorHandler = config.fieldMapperErrorHandler;
        this.mapperBuilderErrorHandler = config.mapperBuilderErrorHandler;
        this.consumerErrorHandler = config.consumerErrorHandler;
        this.columnDefinitions = config.columnDefinitions;
        this.identity = config.identity;
        this.useAsm = config.useAsm;
        this.failOnAsm = config.failOnAsm;
        this.asmMapperNbFieldsLimit = config.asmMapperNbFieldsLimit;
        this.propertyNameMatcherFactory = config.propertyNameMatcherFactory;
        this.reflectionService = config.reflectionService;
        this.maxMethodSize = config.maxMethodSize;
        this.assumeInjectionModifiesValues = config.assumeInjectionModifiesValues;
    }

    public AbstractMapperFactory(AbstractColumnDefinitionProvider<K> columnDefinitions, ColumnDefinition<K, ?> identity) {
        this.columnDefinitions = columnDefinitions;
        this.identity = identity;
    }

    public final MF fieldMapperErrorHandler(FieldMapperErrorHandler<K> fieldMapperErrorHandler) {
        this.fieldMapperErrorHandler = fieldMapperErrorHandler;
        return (MF)this;
    }

    public final MF ignorePropertyNotFound() {
        return this.mapperBuilderErrorHandler(IgnoreMapperBuilderErrorHandler.INSTANCE);
    }

    public final MF mapperBuilderErrorHandler(MapperBuilderErrorHandler mapperBuilderErrorHandler) {
        this.mapperBuilderErrorHandler = mapperBuilderErrorHandler;
        return (MF)this;
    }

    public final MF consumerErrorHandler(ConsumerErrorHandler consumerErrorHandler) {
        this.consumerErrorHandler = consumerErrorHandler;
        return (MF)this;
    }

    @Deprecated
    public final MF rowHandlerErrorHandler(ConsumerErrorHandler rowHandlerErrorHandler) {
        return this.consumerErrorHandler(rowHandlerErrorHandler);
    }

    public final MF useAsm(boolean useAsm) {
        if (this.reflectionService != null) {
            throw new IllegalStateException("Reflection service is set cannot change useAsm");
        }
        this.useAsm = useAsm;
        return (MF)this;
    }

    public final MF reflectionService(ReflectionService reflectionService) {
        this.reflectionService = reflectionService;
        return (MF)this;
    }

    public final MapperConfig<K> mapperConfig() {
        return MapperConfig.config(this.enrichColumnDefinitions(this.columnDefinitions)).mapperBuilderErrorHandler(this.mapperBuilderErrorHandler).propertyNameMatcherFactory(this.propertyNameMatcherFactory).failOnAsm(this.failOnAsm).asmMapperNbFieldsLimit(this.asmMapperNbFieldsLimit).fieldMapperErrorHandler(this.fieldMapperErrorHandler).consumerErrorHandler(this.consumerErrorHandler).maxMethodSize(this.maxMethodSize).assumeInjectionModifiesValues(this.assumeInjectionModifiesValues);
    }

    public AbstractColumnDefinitionProvider<K> enrichColumnDefinitions(AbstractColumnDefinitionProvider<K> columnDefinitions) {
        return columnDefinitions;
    }

    public final MF addAlias(String column, String actualPropertyName) {
        return this.addColumnDefinition(column, (ColumnDefinition<K, ?>)this.identity.addRename(actualPropertyName));
    }

    public final MF addColumnDefinition(String column, ColumnDefinition<K, ?> columnDefinition) {
        this.columnDefinitions.addColumnDefinition(column, columnDefinition);
        return (MF)this;
    }

    public final MF addColumnDefinition(Predicate<? super K> predicate, ColumnDefinition<K, ?> columnDefinition) {
        this.columnDefinitions.addColumnDefinition(predicate, columnDefinition);
        return (MF)this;
    }

    public final MF addColumnProperty(String column, Object ... properties) {
        for (Object property : properties) {
            this.columnDefinitions.addColumnProperty(column, property);
        }
        return (MF)this;
    }

    public final MF addColumnProperty(Predicate<? super K> predicate, Object ... properties) {
        for (Object property : properties) {
            this.columnDefinitions.addColumnProperty(predicate, property);
        }
        return (MF)this;
    }

    public final MF addColumnProperty(Predicate<? super K> predicate, UnaryFactory<K, Object> propertyFactory) {
        this.columnDefinitions.addColumnProperty(predicate, propertyFactory);
        return (MF)this;
    }

    public final MF propertyNameMatcherFactory(PropertyNameMatcherFactory propertyNameMatcherFactory) {
        this.propertyNameMatcherFactory = propertyNameMatcherFactory;
        return (MF)this;
    }

    public final MF addAliases(Map<String, String> aliases) {
        for (Map.Entry<String, String> e : aliases.entrySet()) {
            this.addAlias(e.getKey(), e.getValue());
        }
        return (MF)this;
    }

    public final MF failOnAsm(boolean b) {
        this.failOnAsm = b;
        return (MF)this;
    }

    public final MF assumeInjectionModifiesValues(boolean b) {
        this.assumeInjectionModifiesValues = b;
        return (MF)this;
    }

    public final MF asmMapperNbFieldsLimit(int asmMapperNbFieldsLimit) {
        this.asmMapperNbFieldsLimit = asmMapperNbFieldsLimit;
        return (MF)this;
    }

    public final MF maxMethodSize(int maxMethodSize) {
        this.maxMethodSize = maxMethodSize;
        return (MF)this;
    }

    public final MF addKeys(String ... columns) {
        for (String col : columns) {
            this.addColumnDefinition(col, (ColumnDefinition<K, ?>)this.identity.addKey());
        }
        return (MF)this;
    }

    public final ConsumerErrorHandler consumerErrorHandler() {
        return this.consumerErrorHandler;
    }

    public final <T> ClassMeta<T> getClassMeta(TypeReference<T> target) {
        return this.getClassMeta(target.getType());
    }

    public final <T> ClassMeta<T> getClassMeta(Class<T> target) {
        return this.getClassMeta((Type)target);
    }

    public final <T> ClassMeta<T> getClassMeta(Type target) {
        return this.getReflectionService().getClassMeta(target);
    }

    public final <T> ClassMeta<T> getClassMetaWithExtraInstantiator(TypeReference<T> target, Member instantiator) {
        return this.getClassMetaWithExtraInstantiator(target.getType(), instantiator);
    }

    public final <T> ClassMeta<T> getClassMetaWithExtraInstantiator(Class<T> target, Member instantiator) {
        return this.getClassMetaWithExtraInstantiator((Type)target, instantiator);
    }

    public final <T> ClassMeta<T> getClassMetaWithExtraInstantiator(Type target, Member instantiator) {
        return this.getReflectionService().getClassMetaExtraInstantiator(target, instantiator);
    }

    public ReflectionService getReflectionService() {
        if (this.reflectionService == null) {
            this.reflectionService = ReflectionService.newInstance((boolean)this.useAsm);
        }
        return this.reflectionService;
    }

    public ColumnDefinitionProvider<K> columnDefinitions() {
        return this.columnDefinitions;
    }
}

