/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.map.SourceFieldMapper;
import org.simpleflatmapper.reflect.BiInstantiator;
import org.simpleflatmapper.util.ErrorHelper;

public abstract class AbstractMapper<S, T>
implements SourceFieldMapper<S, T> {
    private final BiInstantiator<? super S, MappingContext<? super S>, T> instantiator;

    public AbstractMapper(BiInstantiator<? super S, MappingContext<? super S>, T> instantiator) {
        this.instantiator = instantiator;
    }

    @Override
    public final T map(S source) throws MappingException {
        return this.map(source, null);
    }

    @Override
    public final T map(S source, MappingContext<? super S> mappingContext) throws MappingException {
        try {
            Object target = this.instantiator.newInstance(source, mappingContext);
            this.mapFields(source, target, mappingContext);
            return (T)target;
        }
        catch (Exception e) {
            return (T)ErrorHelper.rethrow((Throwable)e);
        }
    }

    @Override
    public final void mapTo(S source, T target, MappingContext<? super S> mappingContext) throws MappingException {
        try {
            this.mapToFields(source, target, mappingContext);
        }
        catch (Exception e) {
            ErrorHelper.rethrow((Throwable)e);
        }
    }

    protected abstract void mapFields(S var1, T var2, MappingContext<? super S> var3) throws Exception;

    protected abstract void mapToFields(S var1, T var2, MappingContext<? super S> var3) throws Exception;

    protected void appendToStringBuilder(StringBuilder sb) {
        sb.append("instantiator=").append(String.valueOf(this.instantiator));
    }
}

