/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.fieldmapper;

import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.Mapper;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.util.Asserts;
import org.simpleflatmapper.util.BooleanProvider;
import org.simpleflatmapper.util.Predicate;

public final class MapperFieldMapper<S, T, P>
implements FieldMapper<S, T> {
    private final Mapper<S, P> mapper;
    private final Setter<? super T, ? super P> propertySetter;
    private final Predicate<? super S> nullChecker;
    private final Getter<MappingContext<? super S>, BooleanProvider> breakDetectorProvider;
    private final int currentValueIndex;

    public MapperFieldMapper(Mapper<S, P> mapper, Setter<? super T, ? super P> propertySetter, Predicate<? super S> nullChecker, Getter<MappingContext<? super S>, BooleanProvider> breakDetectorProvider, int currentValueIndex) {
        this.mapper = (Mapper)Asserts.requireNonNull((String)"jdbcMapper", mapper);
        this.propertySetter = (Setter)Asserts.requireNonNull((String)"propertySetter", propertySetter);
        this.nullChecker = (Predicate)Asserts.requireNonNull((String)"nullChecker", nullChecker);
        this.breakDetectorProvider = (Getter)Asserts.requireNonNull((String)"breakDetectorProvider", breakDetectorProvider);
        this.currentValueIndex = currentValueIndex;
    }

    @Override
    public void mapTo(S source, T target, MappingContext<? super S> context) throws Exception {
        if (this.nullChecker.test(source)) {
            return;
        }
        boolean isBroken = ((BooleanProvider)this.breakDetectorProvider.get(context)).getBoolean();
        if (isBroken) {
            P value = this.mapper.map((S)source, (MappingContext<? super S>)context);
            this.propertySetter.set(target, value);
            if (context != null) {
                context.setCurrentValue(this.currentValueIndex, value);
            }
        } else {
            Object value = context.getCurrentValue(this.currentValueIndex);
            if (value == null) {
                throw new NullPointerException();
            }
            this.mapper.mapTo(source, value, context);
        }
    }

    public String toString() {
        return "MapperFieldMapper{jdbcMapper=" + this.mapper + ", propertySetter=" + this.propertySetter + '}';
    }
}

