/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import java.lang.reflect.Type;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.MapperBuilderErrorHandler;
import org.simpleflatmapper.map.context.MappingContextFactoryBuilder;
import org.simpleflatmapper.map.fieldmapper.BooleanFieldMapper;
import org.simpleflatmapper.map.fieldmapper.ByteFieldMapper;
import org.simpleflatmapper.map.fieldmapper.CharacterFieldMapper;
import org.simpleflatmapper.map.fieldmapper.DoubleFieldMapper;
import org.simpleflatmapper.map.fieldmapper.FieldMapperImpl;
import org.simpleflatmapper.map.fieldmapper.FloatFieldMapper;
import org.simpleflatmapper.map.fieldmapper.IntFieldMapper;
import org.simpleflatmapper.map.fieldmapper.LongFieldMapper;
import org.simpleflatmapper.map.fieldmapper.ShortFieldMapper;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.ConstantTargetFieldMapperFactory;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.map.property.SetterFactoryProperty;
import org.simpleflatmapper.map.property.SetterProperty;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.SetterFactory;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.ObjectClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.primitive.BooleanGetter;
import org.simpleflatmapper.reflect.primitive.BooleanSetter;
import org.simpleflatmapper.reflect.primitive.ByteGetter;
import org.simpleflatmapper.reflect.primitive.ByteSetter;
import org.simpleflatmapper.reflect.primitive.CharacterGetter;
import org.simpleflatmapper.reflect.primitive.CharacterSetter;
import org.simpleflatmapper.reflect.primitive.DoubleGetter;
import org.simpleflatmapper.reflect.primitive.DoubleSetter;
import org.simpleflatmapper.reflect.primitive.FloatGetter;
import org.simpleflatmapper.reflect.primitive.FloatSetter;
import org.simpleflatmapper.reflect.primitive.IntGetter;
import org.simpleflatmapper.reflect.primitive.IntSetter;
import org.simpleflatmapper.reflect.primitive.LongGetter;
import org.simpleflatmapper.reflect.primitive.LongSetter;
import org.simpleflatmapper.reflect.primitive.ShortGetter;
import org.simpleflatmapper.reflect.primitive.ShortSetter;
import org.simpleflatmapper.reflect.setter.SetterOnGetter;
import org.simpleflatmapper.util.ErrorDoc;
import org.simpleflatmapper.util.TypeHelper;

public class ConstantTargetFieldMapperFactoryImpl<T, K extends FieldKey<K>>
implements ConstantTargetFieldMapperFactory<T, K> {
    private final SetterFactory<T, PropertyMapping<?, ?, K, ? extends ColumnDefinition<K, ?>>> setterFactory;

    private ConstantTargetFieldMapperFactoryImpl(SetterFactory<T, PropertyMapping<?, ?, K, ? extends ColumnDefinition<K, ?>>> setterFactory) {
        this.setterFactory = setterFactory;
    }

    @Override
    public <S, P> FieldMapper<S, T> newFieldMapper(PropertyMapping<S, P, K, FieldMapperColumnDefinition<K>> pm, MappingContextFactoryBuilder contextFactoryBuilder, MapperBuilderErrorHandler mappingErrorHandler) {
        Getter customGetter = pm.getColumnDefinition().getCustomGetter();
        Getter getter = customGetter != null ? customGetter : pm.getPropertyMeta().getGetter();
        if (getter == null) {
            mappingErrorHandler.accessorNotFound("Could not find getter for " + pm + " See " + ErrorDoc.toUrl((String)"CTFM_GETTER_NOT_FOUND"));
            return null;
        }
        Object setter = null;
        SetterProperty setterProperty = pm.getColumnDefinition().lookFor(SetterProperty.class);
        if (setterProperty != null) {
            setter = setterProperty.getSetter();
        }
        if (setter == null) {
            setter = this.getSetterForTarget(pm);
        }
        if (setter == null) {
            mappingErrorHandler.accessorNotFound("Could not find setter for " + pm + " See " + ErrorDoc.toUrl((String)"CTFM_SETTER_NOT_FOUND"));
            return null;
        }
        Type propertyType = pm.getPropertyMeta().getPropertyType();
        return this.buildFieldMapper((Getter<? super S, ? extends P>)getter, (Setter<? super T, ? super P>)setter, propertyType);
    }

    private <S, P> FieldMapper<S, T> buildFieldMapper(Getter<? super S, ? extends P> getter, Setter<? super T, ? super P> setter, Type propertyType) {
        if (TypeHelper.isPrimitive((Type)propertyType)) {
            if (getter instanceof BooleanGetter && setter instanceof BooleanSetter) {
                return new BooleanFieldMapper((BooleanGetter)getter, (BooleanSetter)setter);
            }
            if (getter instanceof ByteGetter && setter instanceof ByteSetter) {
                return new ByteFieldMapper((ByteGetter)getter, (ByteSetter)setter);
            }
            if (getter instanceof CharacterGetter && setter instanceof CharacterSetter) {
                return new CharacterFieldMapper((CharacterGetter)getter, (CharacterSetter)setter);
            }
            if (getter instanceof ShortGetter && setter instanceof ShortSetter) {
                return new ShortFieldMapper((ShortGetter)getter, (ShortSetter)setter);
            }
            if (getter instanceof IntGetter && setter instanceof IntSetter) {
                return new IntFieldMapper((IntGetter)getter, (IntSetter)setter);
            }
            if (getter instanceof LongGetter && setter instanceof LongSetter) {
                return new LongFieldMapper((LongGetter)getter, (LongSetter)setter);
            }
            if (getter instanceof FloatGetter && setter instanceof FloatSetter) {
                return new FloatFieldMapper((FloatGetter)getter, (FloatSetter)setter);
            }
            if (getter instanceof DoubleGetter && setter instanceof DoubleSetter) {
                return new DoubleFieldMapper((DoubleGetter)getter, (DoubleSetter)setter);
            }
        }
        return new FieldMapperImpl<S, T, P>(getter, setter);
    }

    private <S, P> Setter<T, P> getSetterForTarget(PropertyMapping<S, ?, K, FieldMapperColumnDefinition<K>> pm) {
        PropertyMeta subProp;
        Setter<T, P> subSetter;
        ObjectClassMeta ocm;
        ClassMeta propertyClassMeta;
        Setter setter = null;
        SetterFactoryProperty setterFactoryProperty = pm.getColumnDefinition().lookFor(SetterFactoryProperty.class);
        if (setterFactoryProperty != null) {
            SetterFactory<?, ?> setterFactory = setterFactoryProperty.getSetterFactory();
            setter = setterFactory.getSetter(pm);
        }
        if (setter == null) {
            setter = this.setterFactory.getSetter(pm);
        }
        if (setter == null && (propertyClassMeta = pm.getPropertyMeta().getPropertyClassMeta()) instanceof ObjectClassMeta && (ocm = (ObjectClassMeta)propertyClassMeta).getNumberOfProperties() == 1 && (subSetter = this.getSetterForTarget(pm.propertyMeta(subProp = ocm.getFirstProperty()))) != null) {
            return new SetterOnGetter(subSetter, subProp.getGetter());
        }
        return setter;
    }

    public static <T, K extends FieldKey<K>> ConstantTargetFieldMapperFactory<T, K> newInstance(SetterFactory<T, PropertyMapping<?, ?, K, ? extends ColumnDefinition<K, ?>>> setterFactory) {
        return new ConstantTargetFieldMapperFactoryImpl<T, K>(setterFactory);
    }
}

