/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jooq;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jooq.Field;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.UniqueKey;
import org.jooq.exception.DataAccessException;
import org.jooq.exception.MappingException;
import org.simpleflatmapper.jdbc.JdbcTypeHelper;
import org.simpleflatmapper.jooq.JooqFieldKey;
import org.simpleflatmapper.jooq.JooqJdbcMapperBuilder;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.SetRowMapper;
import org.simpleflatmapper.map.mapper.MapperCache;
import org.simpleflatmapper.map.mapper.MapperKey;
import org.simpleflatmapper.map.mapper.MapperKeyComparator;
import org.simpleflatmapper.map.property.KeyProperty;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.util.AutoCloseableEnumerable;
import org.simpleflatmapper.util.AutoCloseableIterator;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.Closer;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.Enumerable;
import org.simpleflatmapper.util.EnumerableSpliterator;

public final class SelectQueryMapper<T> {
    private final MapperCache<JooqFieldKey, SetRowMapper<ResultSet, ResultSet, T, SQLException>> mapperCache = new MapperCache((MapperKeyComparator)JdbcColumnKeyMapperKeyComparator.INSTANCE);
    private final ClassMeta<T> classMeta;
    private final MapperConfig<JooqFieldKey, ResultSet> mapperConfig;

    protected SelectQueryMapper(ClassMeta<T> classMeta, MapperConfig<JooqFieldKey, ResultSet> mapperConfig) {
        this.classMeta = classMeta;
        this.mapperConfig = mapperConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <SET extends TableLike & ResultQuery> List<T> asList(SET source) throws org.simpleflatmapper.map.MappingException {
        SetRowMapper<ResultSet, ResultSet, T, SQLException> mapper = this.getMapper(source);
        try {
            final ArrayList list = new ArrayList();
            try (ResultSet rs = ((ResultQuery)source).fetchResultSet();){
                mapper.forEach((Object)rs, (CheckedConsumer)new Consumer<T>(){

                    public void accept(T t) {
                        list.add(t);
                    }
                });
            }
            return list;
        }
        catch (org.simpleflatmapper.map.MappingException e) {
            throw new MappingException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            throw new DataAccessException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <SET extends TableLike & ResultQuery, H extends CheckedConsumer<? super T>> H forEach(SET source, H handler) throws org.simpleflatmapper.map.MappingException {
        SetRowMapper<ResultSet, ResultSet, T, SQLException> mapper = this.getMapper(source);
        try (ResultSet rs = ((ResultQuery)source).fetchResultSet();){
            mapper.forEach((Object)rs, handler);
        }
        catch (org.simpleflatmapper.map.MappingException e) {
            throw new MappingException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            throw new DataAccessException(e.getMessage(), (Throwable)e);
        }
        return handler;
    }

    public <SET extends TableLike & ResultQuery> AutoCloseableIterator<T> iterator(SET source) throws org.simpleflatmapper.map.MappingException {
        SetRowMapper<ResultSet, ResultSet, T, SQLException> mapper = this.getMapper(source);
        try {
            ResultSet rs = ((ResultQuery)source).fetchResultSet();
            ExceptionTranslatorIterator iterator = new ExceptionTranslatorIterator(mapper.iterator((Object)rs));
            return new AutoCloseableIterator(iterator, this.closer(rs));
        }
        catch (SQLException e) {
            throw new DataAccessException(e.getMessage(), (Throwable)e);
        }
    }

    public <SET extends TableLike & ResultQuery> Stream<T> stream(SET source) throws org.simpleflatmapper.map.MappingException {
        SetRowMapper<ResultSet, ResultSet, T, SQLException> mapper = this.getMapper(source);
        try {
            final ResultSet rs = ((ResultQuery)source).fetchResultSet();
            ExceptionTranslatorEnumerable enumerate = new ExceptionTranslatorEnumerable(mapper.enumerate((Object)rs));
            Stream stream = StreamSupport.stream(new EnumerableSpliterator(enumerate), false);
            return (Stream)stream.onClose(new Runnable(){

                @Override
                public void run() {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        throw new DataAccessException(e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
        catch (SQLException e) {
            throw new DataAccessException(e.getMessage(), (Throwable)e);
        }
    }

    public <SET extends TableLike & ResultQuery> AutoCloseableEnumerable<T> enumerate(SET source) throws org.simpleflatmapper.map.MappingException {
        SetRowMapper<ResultSet, ResultSet, T, SQLException> mapper = this.getMapper(source);
        try {
            ResultSet rs = ((ResultQuery)source).fetchResultSet();
            ExceptionTranslatorEnumerable enumerable = new ExceptionTranslatorEnumerable(mapper.enumerate((Object)rs));
            return new AutoCloseableEnumerable(enumerable, this.closer(rs));
        }
        catch (SQLException e) {
            throw new DataAccessException(e.getMessage(), (Throwable)e);
        }
    }

    private <SET extends TableLike & ResultQuery> SetRowMapper<ResultSet, ResultSet, T, SQLException> getMapper(SET source) {
        try {
            Field[] fields = this.getFields(source);
            FieldKey[] keys = new JooqFieldKey[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                keys[i] = new JooqFieldKey(fields[i], i);
            }
            MapperKey mapperKey = new MapperKey(keys);
            SetRowMapper<ResultSet, ResultSet, T, SQLException> mapper = (SetRowMapper<ResultSet, ResultSet, T, SQLException>)this.mapperCache.get(mapperKey);
            if (mapper == null) {
                mapper = this.buildMapper(fields);
                this.mapperCache.add(mapperKey, mapper);
            }
            return mapper;
        }
        catch (Exception e) {
            throw new MappingException(e.getMessage(), (Throwable)e);
        }
    }

    private <SET extends TableLike & ResultQuery> Field[] getFields(SET source) {
        if (source instanceof Select) {
            List select = ((Select)source).getSelect();
            return select.toArray(new Field[0]);
        }
        return source.fields();
    }

    private SetRowMapper<ResultSet, ResultSet, T, SQLException> buildMapper(Field[] fields) {
        JooqJdbcMapperBuilder<T> mapperBuilder = new JooqJdbcMapperBuilder<T>(this.classMeta, this.mapperConfig);
        for (int i = 0; i < fields.length; ++i) {
            Object[] objectArray;
            Field field = fields[i];
            if (this.isKey(field)) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = KeyProperty.DEFAULT;
            } else {
                objectArray = new Object[]{};
            }
            Object[] properties = objectArray;
            int sqlType = field.getDataType().getSQLType();
            JooqFieldKey key = new JooqFieldKey(field, i + 1, JdbcTypeHelper.toJavaType((int)sqlType, (Type)field.getType()));
            mapperBuilder.addMapping(key, properties);
        }
        return mapperBuilder.mapper();
    }

    private boolean isKey(Field<?> field) {
        TableField tf;
        List keys;
        if (field instanceof TableField && (keys = (tf = (TableField)field).getTable().getKeys()) != null) {
            for (UniqueKey key : keys) {
                if (!key.getFields().contains(field)) continue;
                return true;
            }
        }
        return false;
    }

    private Closer closer(final ResultSet rs) {
        return new Closer(){

            public void close() {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    throw new DataAccessException(e.getMessage(), (Throwable)e);
                }
            }
        };
    }

    private class ExceptionTranslatorEnumerable<T>
    implements Enumerable<T> {
        private final Enumerable<T> delegate;

        public ExceptionTranslatorEnumerable(Enumerable<T> delegate) {
            this.delegate = delegate;
        }

        public boolean next() {
            try {
                return this.delegate.next();
            }
            catch (org.simpleflatmapper.map.MappingException e) {
                throw new MappingException(e.getMessage(), (Throwable)e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DataAccessException(e.getMessage(), (Throwable)e);
            }
        }

        public T currentValue() {
            try {
                return (T)this.delegate.currentValue();
            }
            catch (org.simpleflatmapper.map.MappingException e) {
                throw new MappingException(e.getMessage(), (Throwable)e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DataAccessException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static class ExceptionTranslatorIterator<T>
    implements Iterator<T> {
        private final Iterator<T> delegate;

        public ExceptionTranslatorIterator(Iterator<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public boolean hasNext() {
            try {
                return this.delegate.hasNext();
            }
            catch (org.simpleflatmapper.map.MappingException e) {
                throw new MappingException(e.getMessage(), (Throwable)e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DataAccessException(e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public T next() {
            try {
                return this.delegate.next();
            }
            catch (org.simpleflatmapper.map.MappingException e) {
                throw new MappingException(e.getMessage(), (Throwable)e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DataAccessException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static final class JdbcColumnKeyMapperKeyComparator
    extends MapperKeyComparator<JooqFieldKey> {
        public static final JdbcColumnKeyMapperKeyComparator INSTANCE = new JdbcColumnKeyMapperKeyComparator();

        private JdbcColumnKeyMapperKeyComparator() {
        }

        public int compare(MapperKey<JooqFieldKey> m1, MapperKey<JooqFieldKey> m2) {
            JooqFieldKey[] keys2;
            JooqFieldKey[] keys1 = (JooqFieldKey[])m1.getColumns();
            int d = keys1.length - (keys2 = (JooqFieldKey[])m2.getColumns()).length;
            if (d != 0) {
                return d;
            }
            return this.compareKeys(keys1, keys2);
        }

        private int compareKeys(JooqFieldKey[] keys1, JooqFieldKey[] keys2) {
            for (int i = 0; i < keys1.length; ++i) {
                int d = this.compare(keys1[i], keys2[i]);
                if (d == 0) continue;
                return d;
            }
            return 0;
        }

        protected int compare(JooqFieldKey k1, JooqFieldKey k2) {
            int d = k1.getIndex() - k2.getIndex();
            if (d != 0) {
                return d;
            }
            d = k1.getField().getName().compareTo(k2.getField().getName());
            return d;
        }
    }
}

