/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jooq;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.RecordMapper;
import org.jooq.RecordMapperProvider;
import org.jooq.RecordType;
import org.sfm.jooq.JooqFieldKey;
import org.sfm.jooq.JooqMapperBuilder;
import org.sfm.jooq.JooqMappingContextFactoryBuilder;
import org.sfm.jooq.JooqRecordMapperWrapper;
import org.sfm.jooq.TargetColumnsMapperKey;
import org.sfm.map.Mapper;
import org.sfm.map.MapperConfig;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.reflect.ReflectionService;

public class SfmRecordMapperProvider
implements RecordMapperProvider {
    private final ConcurrentMap<TargetColumnsMapperKey, Mapper<Record, ?>> mapperCache = new ConcurrentHashMap();
    private final MapperConfig<JooqFieldKey, FieldMapperColumnDefinition<JooqFieldKey>> mapperConfig;
    private final ReflectionService reflectionService;

    public SfmRecordMapperProvider() {
        this((MapperConfig<JooqFieldKey, FieldMapperColumnDefinition<JooqFieldKey>>)MapperConfig.fieldMapperConfig(), ReflectionService.newInstance());
    }

    public SfmRecordMapperProvider(MapperConfig<JooqFieldKey, FieldMapperColumnDefinition<JooqFieldKey>> mapperConfig, ReflectionService reflectionService) {
        this.mapperConfig = mapperConfig;
        this.reflectionService = reflectionService;
    }

    public <R extends Record, E> RecordMapper<R, E> provide(RecordType<R> recordType, Class<? extends E> type) {
        TargetColumnsMapperKey key = this.getMapperKey(recordType, type);
        Mapper<Record, ? extends E> mapper = (Mapper<Record, ? extends E>)this.mapperCache.get(key);
        if (mapper == null) {
            mapper = this.buildMapper(recordType, type);
            this.mapperCache.putIfAbsent(key, mapper);
        }
        return new JooqRecordMapperWrapper(mapper);
    }

    private <R extends Record, E> Mapper<Record, E> buildMapper(RecordType<R> recordType, Class<? extends E> type) {
        JooqMapperBuilder mapperBuilder = new JooqMapperBuilder(this.reflectionService.getClassMeta(type), new JooqMappingContextFactoryBuilder<Record>(), this.mapperConfig);
        int i = 0;
        for (Field field : recordType.fields()) {
            mapperBuilder.addField(new JooqFieldKey(field, i++));
        }
        return mapperBuilder.mapper();
    }

    private <R extends Record> TargetColumnsMapperKey getMapperKey(RecordType<R> recordType, Class<?> type) {
        String[] columns = new String[recordType.size()];
        int i = 0;
        for (Field field : recordType.fields()) {
            columns[i++] = field.getName();
        }
        return new TargetColumnsMapperKey(type, columns);
    }
}

