/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbi3;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.RowMapperFactory;
import org.simpleflatmapper.jdbc.DynamicJdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbi3.DynamicRowMapper;
import org.simpleflatmapper.jdbi3.StaticRowMapper;
import org.simpleflatmapper.map.SourceMapper;
import org.simpleflatmapper.util.BiPredicate;
import org.simpleflatmapper.util.UnaryFactory;

public class SfmRowMapperFactory
implements RowMapperFactory {
    private static final UnaryFactory<Type, SourceMapper<ResultSet, ?>> DEFAULT_FACTORY = new UnaryFactory<Type, SourceMapper<ResultSet, ?>>(){

        public SourceMapper<ResultSet, ?> newInstance(Type type) {
            return JdbcMapperFactory.newInstance().newMapper(type);
        }
    };
    private static final BiPredicate<Type, ConfigRegistry> DEFAULT_ACCEPT_PREDICATE = new BiPredicate<Type, ConfigRegistry>(){

        public boolean test(Type type, ConfigRegistry configRegistry) {
            return true;
        }
    };
    private final UnaryFactory<Type, SourceMapper<ResultSet, ?>> mapperFactory;
    private final ConcurrentMap<Type, RowMapper<?>> cache = new ConcurrentHashMap();
    private final BiPredicate<Type, ConfigRegistry> acceptsPredicate;

    public SfmRowMapperFactory() {
        this(DEFAULT_FACTORY);
    }

    public SfmRowMapperFactory(UnaryFactory<Type, SourceMapper<ResultSet, ?>> mapperFactory) {
        this(DEFAULT_ACCEPT_PREDICATE, mapperFactory);
    }

    public SfmRowMapperFactory(BiPredicate<Type, ConfigRegistry> acceptsPredicate, UnaryFactory<Type, SourceMapper<ResultSet, ?>> mapperFactory) {
        this.mapperFactory = mapperFactory;
        this.acceptsPredicate = acceptsPredicate;
    }

    private <T> RowMapper<T> toRowMapper(SourceMapper<ResultSet, T> resultSetMapper) {
        Object mapper = resultSetMapper instanceof DynamicJdbcMapper ? new DynamicRowMapper((DynamicJdbcMapper)resultSetMapper) : new StaticRowMapper<T>(resultSetMapper);
        return mapper;
    }

    public Optional<RowMapper<?>> build(Type type, ConfigRegistry configRegistry) {
        if (this.acceptsPredicate.test((Object)type, (Object)configRegistry)) {
            SourceMapper resultSetMapper;
            RowMapper cachedMapper;
            RowMapper rowMapper = (RowMapper)this.cache.get(type);
            if (rowMapper == null && (cachedMapper = this.cache.putIfAbsent(type, rowMapper = this.toRowMapper(resultSetMapper = (SourceMapper)this.mapperFactory.newInstance((Object)type)))) != null) {
                rowMapper = cachedMapper;
            }
            return Optional.of(rowMapper);
        }
        return Optional.empty();
    }
}

