/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbi;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.simpleflatmapper.jdbc.DynamicJdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class DynamicSfmResultSetMapper<T>
implements ResultSetMapper<T> {
    private static final String STATEMENT_MAPPER = DynamicSfmResultSetMapper.class.getName() + ".dynamicMapper";
    private final DynamicJdbcMapper<T> dynamicMapper;

    public DynamicSfmResultSetMapper(DynamicJdbcMapper<T> dynamicMapper) {
        this.dynamicMapper = dynamicMapper;
    }

    public T map(int i, ResultSet resultSet, StatementContext statementContext) throws SQLException {
        JdbcMapper mapper = (JdbcMapper)statementContext.getAttribute(STATEMENT_MAPPER);
        if (mapper == null) {
            mapper = this.dynamicMapper.getMapper(resultSet.getMetaData());
            statementContext.setAttribute(STATEMENT_MAPPER, (Object)mapper);
        }
        return (T)mapper.map((Object)resultSet, mapper.newMappingContext((Object)resultSet));
    }
}

