/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import org.simpleflatmapper.converter.ContextFactoryBuilder;
import org.simpleflatmapper.converter.DefaultContextFactoryBuilder;
import org.simpleflatmapper.jdbc.Crud;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.MultiIndexFieldMapper;
import org.simpleflatmapper.jdbc.PreparedStatementMapperBuilder;
import org.simpleflatmapper.jdbc.QueryPreparer;
import org.simpleflatmapper.jdbc.impl.ColumnMeta;
import org.simpleflatmapper.jdbc.impl.CrudMeta;
import org.simpleflatmapper.jdbc.impl.DefaultCrud;
import org.simpleflatmapper.jdbc.impl.KeyTupleQueryPreparer;
import org.simpleflatmapper.jdbc.impl.MysqlCrudFactory;
import org.simpleflatmapper.jdbc.impl.PostgresqlCrudFactory;
import org.simpleflatmapper.jdbc.impl.SelectQueryWhereFactory;
import org.simpleflatmapper.jdbc.impl.UnsupportedQueryPreparer;
import org.simpleflatmapper.jdbc.named.NamedSqlQuery;
import org.simpleflatmapper.reflect.meta.ClassMeta;

public class CrudFactory {
    public static <T, K> Crud<T, K> newInstance(ClassMeta<T> target, ClassMeta<K> keyTarget, CrudMeta crudMeta, JdbcMapperFactory jdbcMapperFactory) throws SQLException {
        JdbcMapperFactory mapperFactory = JdbcMapperFactory.newInstance(jdbcMapperFactory);
        return CrudFactory.createCrud(target, keyTarget, crudMeta, mapperFactory);
    }

    private static <T, K> Crud<T, K> createCrud(ClassMeta<T> target, ClassMeta<K> keyTarget, CrudMeta crudMeta, JdbcMapperFactory mapperFactory) throws SQLException {
        crudMeta.addColumnProperties(mapperFactory);
        QueryPreparer<T> insert = CrudFactory.buildInsert(target, crudMeta, mapperFactory);
        QueryPreparer<T> update = CrudFactory.buildUpdate(target, crudMeta, mapperFactory);
        QueryPreparer<K> select = CrudFactory.buildSelect(keyTarget, crudMeta, mapperFactory);
        QueryPreparer<K> delete = CrudFactory.buildDelete(keyTarget, crudMeta, mapperFactory);
        QueryPreparer<T> upsert = CrudFactory.buildUpsert(target, crudMeta, mapperFactory);
        KeyTupleQueryPreparer<K> keyTupleQueryPreparer = CrudFactory.buildKeyTupleQueryPreparer(keyTarget, crudMeta, mapperFactory);
        JdbcMapper<T> selectMapper = CrudFactory.buildSelectMapper(target, crudMeta, mapperFactory);
        JdbcMapper<K> keyMapper = CrudFactory.buildKeyMapper(keyTarget, crudMeta, mapperFactory);
        boolean hasGeneratedKeys = crudMeta.hasGeneratedKeys();
        DefaultCrud<T, K> defaultCrud = new DefaultCrud<T, K>(insert, update, select, upsert, keyTupleQueryPreparer, selectMapper, delete, keyMapper, crudMeta, hasGeneratedKeys, new SelectQueryWhereFactory<T>(crudMeta, selectMapper, mapperFactory));
        if (crudMeta.getDatabaseMeta().isMysql()) {
            return MysqlCrudFactory.newInstance(target, keyTarget, crudMeta, mapperFactory, defaultCrud);
        }
        if (crudMeta.getDatabaseMeta().isPostgresSql()) {
            return PostgresqlCrudFactory.newInstance(target, keyTarget, crudMeta, mapperFactory, defaultCrud);
        }
        return defaultCrud;
    }

    private static <T, K> QueryPreparer<T> buildUpsert(ClassMeta<T> target, CrudMeta crudMeta, JdbcMapperFactory mapperFactory) {
        if (crudMeta.getDatabaseMeta().isMysql()) {
            return MysqlCrudFactory.buildUpsert(target, crudMeta, mapperFactory);
        }
        if (crudMeta.getDatabaseMeta().isPostgresSql() && crudMeta.getDatabaseMeta().isVersionMet(9, 5)) {
            return PostgresqlCrudFactory.buildUpsert(target, crudMeta, mapperFactory);
        }
        return new UnsupportedQueryPreparer("Upsert Not Supported on " + String.valueOf(crudMeta.getDatabaseMeta()));
    }

    private static <T, K> KeyTupleQueryPreparer<K> buildKeyTupleQueryPreparer(ClassMeta<K> keyTarget, CrudMeta crudMeta, JdbcMapperFactory jdbcMapperFactory) {
        PreparedStatementMapperBuilder<K> builder = jdbcMapperFactory.from(keyTarget);
        ArrayList<String> primaryKeys = new ArrayList<String>();
        int i = 1;
        for (ColumnMeta cm : crudMeta.getColumnMetas()) {
            if (!cm.isKey()) continue;
            primaryKeys.add(cm.getColumn());
            builder.addColumn(cm.toJdbcColumnKey(i), new Object[0]);
            ++i;
        }
        DefaultContextFactoryBuilder contextFactoryBuilder = new DefaultContextFactoryBuilder();
        MultiIndexFieldMapper<K>[] multiIndexFieldMappers = builder.buildIndexFieldMappers((ContextFactoryBuilder)contextFactoryBuilder);
        return new KeyTupleQueryPreparer<K>(multiIndexFieldMappers, contextFactoryBuilder.build(), primaryKeys.toArray(new String[0]));
    }

    private static <T, K> JdbcMapper<K> buildKeyMapper(ClassMeta<K> keyTarget, CrudMeta crudMeta, JdbcMapperFactory jdbcMapperFactory) {
        JdbcMapperBuilder<K> mapperBuilder = jdbcMapperFactory.newBuilder(keyTarget);
        int i = 1;
        for (ColumnMeta cm : crudMeta.getColumnMetas()) {
            if (!cm.isKey()) continue;
            mapperBuilder.addMapping(cm.toJdbcColumnKey(i), new Object[0]);
            ++i;
        }
        if (i == 1) {
            throw new IllegalArgumentException("No key defined to map to " + String.valueOf(keyTarget.getType()) + ", specify key using DSL or add a primary key to the table");
        }
        return (JdbcMapper)mapperBuilder.mapper();
    }

    private static <T, K> JdbcMapper<T> buildSelectMapper(ClassMeta<T> target, CrudMeta crudMeta, JdbcMapperFactory jdbcMapperFactory) throws SQLException {
        JdbcMapperBuilder<T> mapperBuilder = jdbcMapperFactory.newBuilder(target);
        int i = 1;
        for (ColumnMeta cm : crudMeta.getColumnMetas()) {
            mapperBuilder.addMapping(cm.toJdbcColumnKey(i), new Object[0]);
            ++i;
        }
        return (JdbcMapper)mapperBuilder.mapper();
    }

    private static <T, K> QueryPreparer<T> buildInsert(ClassMeta<T> target, CrudMeta crudMeta, JdbcMapperFactory jdbcMapperFactory) throws SQLException {
        ArrayList<String> generatedKeys = new ArrayList<String>();
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        CrudFactory.appendTableName(sb, crudMeta);
        sb.append("(");
        boolean first = true;
        for (ColumnMeta cm : crudMeta.getColumnMetas()) {
            if (cm.isInsertable()) {
                if (!first) {
                    sb.append(", ");
                }
                crudMeta.appendProtectedField(sb, cm.getColumn());
                first = false;
            }
            if (!cm.isGenerated()) continue;
            generatedKeys.add(cm.getColumn());
        }
        sb.append(") VALUES(");
        first = true;
        for (ColumnMeta cm : crudMeta.getColumnMetas()) {
            if (!cm.isInsertable()) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append(cm.getInsertExpression());
            first = false;
        }
        sb.append(")");
        return jdbcMapperFactory.from(target).to(NamedSqlQuery.parse(sb), generatedKeys.isEmpty() ? null : generatedKeys.toArray(new String[0]));
    }

    private static <T, K> QueryPreparer<T> buildUpdate(ClassMeta<T> target, CrudMeta crudMeta, JdbcMapperFactory jdbcMapperFactory) throws SQLException {
        StringBuilder sb = new StringBuilder("UPDATE ");
        CrudFactory.appendTableName(sb, crudMeta);
        sb.append(" SET ");
        boolean first = true;
        for (ColumnMeta cm : crudMeta.getColumnMetas()) {
            String columnName = cm.getColumn();
            if (cm.isKey()) continue;
            if (!first) {
                sb.append(", ");
            }
            crudMeta.appendProtectedField(sb, columnName);
            sb.append(" = ?");
            first = false;
        }
        if (first) {
            return null;
        }
        CrudFactory.addWhereOnPrimaryKeys(crudMeta, sb);
        return jdbcMapperFactory.from(target).to(NamedSqlQuery.parse(sb));
    }

    private static <T, K> QueryPreparer<K> buildSelect(ClassMeta<K> keyTarget, CrudMeta crudMeta, JdbcMapperFactory jdbcMapperFactory) throws SQLException {
        StringBuilder sb = new StringBuilder("SELECT ");
        boolean first = true;
        for (ColumnMeta cm : crudMeta.getColumnMetas()) {
            if (!first) {
                sb.append(", ");
            }
            crudMeta.appendProtectedField(sb, cm.getColumn());
            first = false;
        }
        sb.append(" FROM ");
        CrudFactory.appendTableName(sb, crudMeta);
        CrudFactory.addWhereOnPrimaryKeys(crudMeta, sb);
        return jdbcMapperFactory.from(keyTarget).to(NamedSqlQuery.parse(sb));
    }

    private static void appendTableName(StringBuilder sb, CrudMeta crudMeta) {
        crudMeta.appendTableName(sb);
    }

    private static <T, K> QueryPreparer<K> buildDelete(ClassMeta<K> keyTarget, CrudMeta crudMeta, JdbcMapperFactory jdbcMapperFactory) throws SQLException {
        StringBuilder sb = new StringBuilder("DELETE FROM ");
        CrudFactory.appendTableName(sb, crudMeta);
        CrudFactory.addWhereOnPrimaryKeys(crudMeta, sb);
        return jdbcMapperFactory.from(keyTarget).to(NamedSqlQuery.parse(sb));
    }

    private static <T, K> void addWhereOnPrimaryKeys(CrudMeta crudMeta, StringBuilder sb) {
        sb.append(" WHERE ");
        boolean first = true;
        for (ColumnMeta cm : crudMeta.getColumnMetas()) {
            if (!cm.isKey()) continue;
            if (!first) {
                sb.append("AND ");
            }
            crudMeta.appendProtectedField(sb, cm.getColumn());
            sb.append(" = ? ");
            first = false;
        }
    }
}

