/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl.getter;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.simpleflatmapper.converter.Context;
import org.simpleflatmapper.map.getter.ContextualGetter;
import org.simpleflatmapper.map.getter.FloatContextualGetter;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.primitive.FloatGetter;

public final class FloatResultSetGetter
implements FloatGetter<ResultSet>,
Getter<ResultSet, Float>,
FloatContextualGetter<ResultSet>,
ContextualGetter<ResultSet, Float> {
    private final int column;

    public FloatResultSetGetter(int column) {
        this.column = column;
    }

    public float getFloat(ResultSet target) throws SQLException {
        return target.getFloat(this.column);
    }

    public Float get(ResultSet target) throws Exception {
        float f = this.getFloat(target);
        if (f == 0.0f && target.wasNull()) {
            return null;
        }
        return Float.valueOf(f);
    }

    public Float get(ResultSet resultSet, Context context) throws Exception {
        return this.get(resultSet);
    }

    public float getFloat(ResultSet resultSet, Context mappingContext) throws Exception {
        return this.getFloat(resultSet);
    }

    public String toString() {
        return "FloatResultSetGetter{property=" + this.column + "}";
    }
}

