/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl.getter;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.simpleflatmapper.converter.Context;
import org.simpleflatmapper.map.getter.ContextualGetter;
import org.simpleflatmapper.reflect.Getter;

public final class UndefinedDateResultSetGetter
implements Getter<ResultSet, Date>,
ContextualGetter<ResultSet, Date> {
    private final int column;

    public UndefinedDateResultSetGetter(int column) {
        this.column = column;
    }

    public Date get(ResultSet target) throws SQLException {
        Object o = target.getObject(this.column);
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof Number) {
            return new Date(((Number)o).longValue());
        }
        throw new SQLException("Expected date, cannot convert " + String.valueOf(o) + " to date");
    }

    public Date get(ResultSet resultSet, Context context) throws Exception {
        return this.get(resultSet);
    }

    public String toString() {
        return "UndefinedDateResultSetGetter{property=" + this.column + "}";
    }
}

