/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.SqlTypeColumnProperty;
import org.simpleflatmapper.jdbc.impl.ColumnMeta;
import org.simpleflatmapper.jdbc.impl.DatabaseMeta;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.ColumnDefinitionProvider;
import org.simpleflatmapper.map.property.AutoGeneratedProperty;
import org.simpleflatmapper.map.property.IgnoreAutoGeneratedProperty;
import org.simpleflatmapper.map.property.KeyProperty;

public class CrudMeta {
    private final DatabaseMeta databaseMeta;
    private final String schema;
    private final String table;
    private final ColumnMeta[] columnMetas;

    public CrudMeta(DatabaseMeta databaseMeta, String schema, String table, ColumnMeta[] columnMetas) {
        this.databaseMeta = databaseMeta;
        this.schema = "".equals(schema) ? null : schema;
        this.table = table;
        this.columnMetas = columnMetas;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public String getTable() {
        return this.table;
    }

    public ColumnMeta[] getColumnMetas() {
        return this.columnMetas;
    }

    public boolean hasGeneratedKeys() {
        for (ColumnMeta cm : this.columnMetas) {
            if (!cm.isKey() || !cm.isGenerated()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CrudMeta of(Connection connection, String table, ColumnDefinitionProvider<JdbcColumnKey> columnDefinitionProvider) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        DatabaseMeta databaseMeta = new DatabaseMeta(metaData.getDatabaseProductName(), metaData.getDatabaseMajorVersion(), metaData.getDatabaseMinorVersion());
        try (Statement statement = connection.createStatement();){
            CrudMeta crudMeta;
            ResultSet resultSet = statement.executeQuery(CrudMeta.selectProtected(table, databaseMeta));
            try {
                crudMeta = CrudMeta.getCrudMeta(connection, table, columnDefinitionProvider, resultSet, databaseMeta);
            }
            catch (Throwable throwable) {
                try {
                    resultSet.close();
                    throw throwable;
                }
                catch (SQLException e) {
                    try (ResultSet resultSet2 = statement.executeQuery("SELECT * FROM " + table + " WHERE 1 = 2");){
                        CrudMeta crudMeta2 = CrudMeta.getCrudMeta(connection, table, columnDefinitionProvider, resultSet2, databaseMeta);
                        return crudMeta2;
                    }
                }
            }
            resultSet.close();
            return crudMeta;
        }
    }

    private static String selectProtected(String table, DatabaseMeta dm) {
        if (dm.isMysql()) {
            return "SELECT * FROM `" + table + "` WHERE 1 = 2";
        }
        return "SELECT * FROM \"" + table + "\" WHERE 1 = 2";
    }

    private static CrudMeta getCrudMeta(Connection connection, String _table, ColumnDefinitionProvider<JdbcColumnKey> columnDefinitionProvider, ResultSet resultSet, DatabaseMeta databaseMeta) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        ColumnMeta[] columnMetas = new ColumnMeta[resultSetMetaData.getColumnCount()];
        List<String> primaryKeys = CrudMeta.getPrimaryKeys(connection, resultSetMetaData, columnDefinitionProvider);
        String table = _table;
        String schema = null;
        int length = columnMetas.length;
        if (length > 0) {
            table = resultSetMetaData.getTableName(1);
            schema = resultSetMetaData.getSchemaName(1);
        }
        for (int i = 0; i < length; ++i) {
            String columnName = resultSetMetaData.getColumnName(i + 1);
            ColumnDefinition columnDefinition = columnDefinitionProvider.getColumnDefinition((FieldKey)JdbcColumnKey.of(resultSetMetaData, i + 1));
            AutoGeneratedProperty autoGeneratedProperty = (AutoGeneratedProperty)columnDefinition.lookFor(AutoGeneratedProperty.class);
            if (autoGeneratedProperty == null && resultSetMetaData.isAutoIncrement(i + 1) && !columnDefinition.has(IgnoreAutoGeneratedProperty.class)) {
                autoGeneratedProperty = AutoGeneratedProperty.DEFAULT;
            }
            columnMetas[i] = new ColumnMeta(columnName, resultSetMetaData.getColumnType(i + 1), primaryKeys.contains(columnName), autoGeneratedProperty);
        }
        return new CrudMeta(databaseMeta, schema, table, columnMetas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getPrimaryKeys(Connection connection, ResultSetMetaData resultSetMetaData, ColumnDefinitionProvider<JdbcColumnKey> columnDefinitionProvider) throws SQLException {
        ArrayList<String> primaryKeys = new ArrayList<String>();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            JdbcColumnKey key = JdbcColumnKey.of(resultSetMetaData, i);
            if (!columnDefinitionProvider.getColumnDefinition((FieldKey)key).has(KeyProperty.class)) continue;
            primaryKeys.add(key.getName());
        }
        if (!primaryKeys.isEmpty()) {
            return primaryKeys;
        }
        try (ResultSet set = connection.getMetaData().getPrimaryKeys(resultSetMetaData.getCatalogName(1), resultSetMetaData.getSchemaName(1), resultSetMetaData.getTableName(1));){
            while (set.next()) {
                primaryKeys.add(set.getString("COLUMN_NAME"));
            }
        }
        return primaryKeys;
    }

    public void addColumnProperties(JdbcMapperFactory mapperFactory) {
        for (ColumnMeta columnMeta : this.columnMetas) {
            mapperFactory.addColumnProperty(columnMeta.getColumn(), new Object[]{SqlTypeColumnProperty.of(columnMeta.getSqlType())});
            if (!columnMeta.isKey()) continue;
            mapperFactory.addColumnProperty(columnMeta.getColumn(), new Object[]{KeyProperty.DEFAULT});
        }
    }

    public boolean hasNoUpdatableFields() {
        for (ColumnMeta cm : this.getColumnMetas()) {
            if (cm.isKey()) continue;
            return false;
        }
        return true;
    }

    public StringBuilder appendProtectedField(StringBuilder sb, String value) {
        char c = '\"';
        if (this.databaseMeta.isMysql()) {
            c = '`';
        }
        return sb.append(c).append(value).append(c);
    }

    public void appendTableName(StringBuilder sb) {
        if (this.schema != null) {
            this.appendProtectedField(sb, this.schema);
            sb.append(".");
        }
        this.appendProtectedField(sb, this.table);
    }
}

