/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.converter.Converter;
import org.simpleflatmapper.converter.UncheckedConverter;
import org.simpleflatmapper.converter.UncheckedConverterHelper;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperBuilder;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.JdbcSourceFieldMapper;
import org.simpleflatmapper.jdbc.impl.ResultSetEnumerable;
import org.simpleflatmapper.map.ConsumerErrorHandler;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.SourceFieldMapper;
import org.simpleflatmapper.map.context.MappingContextFactoryFromRows;
import org.simpleflatmapper.map.mapper.DiscriminatorMapper;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.util.Enumerable;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeReference;
import org.simpleflatmapper.util.UnaryFactory;

public class DiscriminatorJdbcBuilder<T> {
    private final String column;
    private final JdbcMapperFactory jdbcMapperFactory;
    private final List<DiscriminatorJdbcSubBuilder> builders = new ArrayList<DiscriminatorJdbcSubBuilder>();

    public DiscriminatorJdbcBuilder(String column, JdbcMapperFactory jdbcMapperFactory) {
        this.column = column;
        this.jdbcMapperFactory = jdbcMapperFactory;
    }

    public DiscriminatorJdbcSubBuilder when(String value, Type type) {
        return this.when(new DiscriminatorPredicate(value), type);
    }

    public DiscriminatorJdbcSubBuilder when(Predicate<String> predicate, Type type) {
        DiscriminatorJdbcSubBuilder subBuilder = new DiscriminatorJdbcSubBuilder(predicate, type);
        this.builders.add(subBuilder);
        return subBuilder;
    }

    public DiscriminatorJdbcSubBuilder when(String value, Class<? extends T> type) {
        return this.when(value, (Type)type);
    }

    public DiscriminatorJdbcSubBuilder when(String value, TypeReference<? extends T> type) {
        return this.when(value, type.getType());
    }

    public JdbcMapper<T> mapper() {
        ArrayList mappers = new ArrayList();
        for (DiscriminatorJdbcSubBuilder subBuilder : this.builders) {
            JdbcSourceFieldMapper mapper = subBuilder.createMapper();
            ResultSetDiscriminatorPredicate predicate = new ResultSetDiscriminatorPredicate(this.column, (Predicate<String>)subBuilder.predicate);
            mappers.add(new DiscriminatorMapper.PredicatedMapper((Predicate)predicate, (SourceFieldMapper)mapper, (MappingContextFactoryFromRows)mapper));
        }
        DiscriminatorJdbcMapper discriminatorMapper = new DiscriminatorJdbcMapper(mappers, new UnaryFactory<ResultSet, Enumerable<ResultSet>>(){

            public Enumerable<ResultSet> newInstance(ResultSet resultSet) {
                return new ResultSetEnumerable(resultSet);
            }
        }, (UncheckedConverter<ResultSet, String>)UncheckedConverterHelper.toUnchecked((Converter)new Converter<ResultSet, String>(){

            public String convert(ResultSet in) throws SQLException {
                return DiscriminatorJdbcBuilder.this.column + ":" + in.getObject(DiscriminatorJdbcBuilder.this.column);
            }
        }), this.jdbcMapperFactory.consumerErrorHandler());
        return discriminatorMapper;
    }

    public class DiscriminatorJdbcSubBuilder {
        private final Type type;
        private final Predicate<String> predicate;
        private JdbcMapperBuilder<T> builder = null;

        public DiscriminatorJdbcSubBuilder(Predicate<String> predicate, Type type) {
            this.type = type;
            this.predicate = predicate;
        }

        public DiscriminatorJdbcSubBuilder addMapping(String column) {
            return this.addMapping(column, (FieldMapperColumnDefinition<JdbcColumnKey>)FieldMapperColumnDefinition.identity());
        }

        public DiscriminatorJdbcSubBuilder addMapping(String column, FieldMapperColumnDefinition<JdbcColumnKey> columnDefinition) {
            this.initBuilder();
            this.builder.addMapping(column, columnDefinition);
            return this;
        }

        private void initBuilder() {
            if (this.builder == null) {
                this.builder = DiscriminatorJdbcBuilder.this.jdbcMapperFactory.newBuilder(this.type);
            }
        }

        public DiscriminatorJdbcSubBuilder addMapping(String column, int index, FieldMapperColumnDefinition<JdbcColumnKey> columnDefinition) {
            this.initBuilder();
            this.builder.addMapping(column, index, columnDefinition);
            return this;
        }

        public JdbcMapper<T> mapper() {
            return DiscriminatorJdbcBuilder.this.mapper();
        }

        public DiscriminatorJdbcSubBuilder when(String value, Type type) {
            return DiscriminatorJdbcBuilder.this.when(value, type);
        }

        public DiscriminatorJdbcSubBuilder when(String value, Class<? extends T> type) {
            return this.when(value, (Type)type);
        }

        public DiscriminatorJdbcSubBuilder when(String value, TypeReference<? extends T> type) {
            return this.when(value, type.getType());
        }

        public DiscriminatorJdbcSubBuilder when(Predicate<String> predicate, Type type) {
            return DiscriminatorJdbcBuilder.this.when(predicate, type);
        }

        private JdbcSourceFieldMapper<T> createMapper() {
            if (this.builder != null) {
                return this.builder.newSourceFieldMapper();
            }
            return DiscriminatorJdbcBuilder.this.jdbcMapperFactory.newSourceFieldMapper(this.type);
        }
    }

    private static class ResultSetDiscriminatorPredicate
    implements Predicate<ResultSet> {
        private final String discriminatorColumn;
        private final Predicate<String> predicate;

        public ResultSetDiscriminatorPredicate(String discriminatorColumn, Predicate<String> predicate) {
            this.discriminatorColumn = discriminatorColumn;
            this.predicate = predicate;
        }

        public boolean test(ResultSet resultSet) {
            try {
                return this.predicate.test((Object)resultSet.getString(this.discriminatorColumn));
            }
            catch (SQLException e) {
                return (Boolean)ErrorHelper.rethrow((Throwable)e);
            }
        }
    }

    private static class DiscriminatorPredicate
    implements Predicate<String> {
        private final String value;

        private DiscriminatorPredicate(String value) {
            this.value = value;
        }

        public boolean test(String discriminatorValue) {
            return this.value == null ? discriminatorValue == null : this.value.equals(discriminatorValue);
        }

        public String toString() {
            return "DiscriminatorPredicate{value='" + this.value + '\'' + '}';
        }
    }

    private static class DiscriminatorJdbcMapper<T>
    extends DiscriminatorMapper<ResultSet, ResultSet, T, SQLException>
    implements JdbcMapper<T> {
        public DiscriminatorJdbcMapper(List<DiscriminatorMapper.PredicatedMapper<ResultSet, ResultSet, T, SQLException>> predicatedMappers, UnaryFactory<ResultSet, Enumerable<ResultSet>> rowEnumerableFactory, UncheckedConverter<ResultSet, String> errorConverter, ConsumerErrorHandler consumerErrorHandler) {
            super(predicatedMappers, rowEnumerableFactory, errorConverter, consumerErrorHandler);
        }

        public MappingContext<? super ResultSet> newMappingContext(ResultSet resultSet) throws SQLException {
            return ((JdbcSourceFieldMapper)this.getMapper(resultSet)).newMappingContext(resultSet);
        }
    }
}

