/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc;

import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.Collection;
import org.simpleflatmapper.jdbc.ConnectedSelectQuery;
import org.simpleflatmapper.jdbc.Crud;
import org.simpleflatmapper.jdbc.SelectQuery;
import org.simpleflatmapper.jdbc.impl.Transaction;
import org.simpleflatmapper.jdbc.impl.TransactionFactory;
import org.simpleflatmapper.util.CheckedConsumer;

public class ConnectedCrud<T, K> {
    private final TransactionFactory transactionFactory;
    private final Crud<T, K> delegate;

    public ConnectedCrud(TransactionFactory transactionFactory, Crud<T, K> delegate) {
        this.transactionFactory = transactionFactory;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(T value) throws SQLException {
        try (Transaction tx = this.newTransaction();){
            this.delegate.create(tx.connection(), value);
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(Collection<T> values) throws SQLException {
        try (Transaction tx = this.newTransaction();){
            this.delegate.create(tx.connection(), values);
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RH extends CheckedConsumer<? super K>> RH create(T value, RH keyConsumer) throws SQLException {
        try (Transaction tx = this.newTransaction();){
            this.delegate.create(tx.connection(), value, keyConsumer);
            tx.commit();
        }
        return keyConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RH extends CheckedConsumer<? super K>> RH create(Collection<T> values, RH keyConsumer) throws SQLException {
        try (Transaction tx = this.newTransaction();){
            this.delegate.create(tx.connection(), values, keyConsumer);
            tx.commit();
        }
        return keyConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T read(K key) throws SQLException {
        T value = null;
        try (Transaction tx = this.newTransaction();){
            value = this.delegate.read(tx.connection(), key);
            tx.commit();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RH extends CheckedConsumer<? super T>> RH read(Collection<K> keys, RH consumer) throws SQLException {
        try (Transaction tx = this.newTransaction();){
            this.delegate.read(tx.connection(), keys, consumer);
            tx.commit();
        }
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(T value) throws SQLException {
        try (Transaction tx = this.newTransaction();){
            this.delegate.update(tx.connection(), value);
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Collection<T> values) throws SQLException {
        try (Transaction tx = this.newTransaction();){
            this.delegate.update(tx.connection(), values);
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(K key) throws SQLException {
        try (Transaction tx = this.newTransaction();){
            this.delegate.delete(tx.connection(), key);
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Collection<K> keys) throws SQLException {
        try (Transaction tx = this.newTransaction();){
            this.delegate.delete(tx.connection(), keys);
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOrUpdate(T value) throws SQLException {
        try (Transaction tx = this.newTransaction();){
            this.delegate.createOrUpdate(tx.connection(), value);
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOrUpdate(Collection<T> values) throws SQLException {
        try (Transaction tx = this.newTransaction();){
            this.delegate.createOrUpdate(tx.connection(), values);
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RH extends CheckedConsumer<? super K>> RH createOrUpdate(T value, RH keyConsumer) throws SQLException {
        try (Transaction tx = this.newTransaction();){
            this.delegate.createOrUpdate(tx.connection(), value, keyConsumer);
            tx.commit();
        }
        return keyConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RH extends CheckedConsumer<? super K>> RH createOrUpdate(Collection<T> values, RH keyConsumer) throws SQLException {
        try (Transaction tx = this.newTransaction();){
            this.delegate.createOrUpdate(tx.connection(), values, keyConsumer);
            tx.commit();
        }
        return keyConsumer;
    }

    public Crud<T, K> crud() {
        return this.delegate;
    }

    public <P> ConnectedSelectQuery<T, P> where(String whereClause, Type paramClass) {
        SelectQuery selectQuery = this.delegate.where(whereClause, paramClass);
        return new ConnectedSelectQuery(selectQuery, this.transactionFactory);
    }

    private Transaction newTransaction() throws SQLException {
        return this.transactionFactory.newTransaction();
    }
}

