/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl;

import java.sql.Connection;
import java.sql.SQLException;
import org.simpleflatmapper.util.ErrorHelper;

public class Transaction {
    private final Connection connection;

    public Transaction(Connection connection) {
        this.connection = connection;
    }

    public Connection connection() {
        return this.connection;
    }

    public void commit() throws SQLException {
        if (!this.connection.getAutoCommit()) {
            this.connection.commit();
        }
    }

    public void handleError(Throwable e) throws SQLException {
        try {
            if (!this.connection.getAutoCommit()) {
                this.connection.rollback();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ErrorHelper.rethrow((Throwable)e);
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

