/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import org.simpleflatmapper.jdbc.MultiIndexFieldMapper;
import org.simpleflatmapper.jdbc.impl.BatchQueryExecutor;
import org.simpleflatmapper.jdbc.impl.CrudMeta;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.ErrorHelper;

public abstract class AbstractBatchInsertQueryExecutor<T>
implements BatchQueryExecutor<T> {
    protected final String[] insertColumns;
    protected final String[] insertColumnExpressions;
    protected final String[] updateColumns;
    protected final String[] generatedKeys;
    protected final MultiIndexFieldMapper<T>[] multiIndexFieldMappers;
    private final CrudMeta meta;

    public AbstractBatchInsertQueryExecutor(CrudMeta meta, String[] insertColumns, String[] insertColumnExpressions, String[] updateColumns, String[] generatedKeys, MultiIndexFieldMapper<T>[] multiIndexFieldMappers) {
        this.meta = meta;
        this.insertColumns = insertColumns;
        this.insertColumnExpressions = insertColumnExpressions;
        this.updateColumns = updateColumns;
        this.generatedKeys = generatedKeys;
        this.multiIndexFieldMappers = multiIndexFieldMappers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(Connection connection, Collection<T> values, CheckedConsumer<PreparedStatement> postExecute) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement(connection, values.size());
        try {
            this.bindTo(preparedStatement, values);
            preparedStatement.executeUpdate();
            postExecute.accept((Object)preparedStatement);
        }
        catch (Exception e) {
            ErrorHelper.rethrow((Throwable)e);
        }
        finally {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    private PreparedStatement prepareStatement(Connection connection, int batchSize) throws SQLException {
        StringBuilder sb = this.createQuery(batchSize);
        if (this.generatedKeys.length == 0) {
            return connection.prepareStatement(sb.toString());
        }
        return connection.prepareStatement(sb.toString(), this.generatedKeys);
    }

    private StringBuilder createQuery(int size) {
        StringBuilder sb = new StringBuilder();
        this.insertInto(sb);
        this.values(size, sb);
        if (this.updateColumns != null) {
            this.onDuplicateKeys(sb);
        }
        return sb;
    }

    protected abstract void onDuplicateKeys(StringBuilder var1);

    private void values(int size, StringBuilder sb) {
        sb.append(" VALUES");
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("(");
            this.appendValueExpressions(sb);
            sb.append(")");
        }
    }

    private void appendValueExpressions(StringBuilder sb) {
        for (int j = 0; j < this.insertColumns.length; ++j) {
            if (j > 0) {
                sb.append(", ");
            }
            if (this.insertColumnExpressions == null || this.insertColumnExpressions[j] == null) {
                sb.append("?");
                continue;
            }
            sb.append(this.insertColumnExpressions[j]);
        }
    }

    private void insertInto(StringBuilder sb) {
        this.appendInsertInto(sb);
        this.meta.appendTableName(sb);
        sb.append("(");
        for (int j = 0; j < this.insertColumns.length; ++j) {
            if (j > 0) {
                sb.append(", ");
            }
            sb.append(this.insertColumns[j]);
        }
        sb.append(")");
    }

    protected void appendInsertInto(StringBuilder sb) {
        sb.append("INSERT INTO ");
    }

    private void bindTo(PreparedStatement preparedStatement, Collection<T> values) throws Exception {
        int i = 0;
        for (T value : values) {
            for (MultiIndexFieldMapper<T> multiIndexFieldMapper : this.multiIndexFieldMappers) {
                multiIndexFieldMapper.map(preparedStatement, value, i);
                ++i;
            }
        }
    }
}

