/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.simpleflatmapper.jdbc.QueryBinder;
import org.simpleflatmapper.jdbc.impl.MapperQueryPreparer;
import org.simpleflatmapper.util.ErrorHelper;

public class MapperQueryBinder<T>
implements QueryBinder<T> {
    private final MapperQueryPreparer<T> queryPreparer;
    private final Connection connection;

    public MapperQueryBinder(MapperQueryPreparer<T> queryPreparer, Connection connection) {
        this.queryPreparer = queryPreparer;
        this.connection = connection;
    }

    @Override
    public PreparedStatement bind(T value) throws SQLException {
        PreparedStatement preparedStatement = this.queryPreparer.prepareStatement(this.connection);
        try {
            this.queryPreparer.mapper().mapTo(value, (Object)preparedStatement, null);
            return preparedStatement;
        }
        catch (Exception t) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorHelper.rethrow((Throwable)t);
            return null;
        }
    }

    @Override
    public void bindTo(T value, PreparedStatement ps) throws SQLException {
        try {
            this.queryPreparer.mapper().mapTo(value, (Object)ps, null);
        }
        catch (Exception e) {
            ErrorHelper.rethrow((Throwable)e);
        }
    }
}

