/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.simpleflatmapper.jdbc.SQLFunction;
import org.simpleflatmapper.jdbc.TransactionTemplate;
import org.simpleflatmapper.util.ErrorHelper;

public class DataSourceTransactionTemplate
implements TransactionTemplate {
    private final DataSource dataSource;

    public DataSourceTransactionTemplate(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R doInTransaction(SQLFunction<? super Connection, ? extends R> sqlFunction) throws SQLException {
        Connection connection = this.dataSource.getConnection();
        try {
            R r = sqlFunction.apply(connection);
            this.commit(connection);
            R r2 = r;
            return r2;
        }
        catch (Throwable e) {
            this.handleError(e, connection);
            R r = null;
            return r;
        }
        finally {
            this.close(connection);
        }
    }

    private void commit(Connection connection) throws SQLException {
        if (!connection.getAutoCommit()) {
            connection.commit();
        }
    }

    private void handleError(Throwable e, Connection connection) throws SQLException {
        try {
            if (!connection.getAutoCommit()) {
                connection.rollback();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ErrorHelper.rethrow((Throwable)e);
    }

    private void close(Connection connection) {
        try {
            connection.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

