/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc;

import java.lang.reflect.Type;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import org.simpleflatmapper.jdbc.JdbcTypeHelper;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.mapper.MapperKey;
import org.simpleflatmapper.reflect.TypeAffinity;

public final class JdbcColumnKey
extends FieldKey<JdbcColumnKey>
implements TypeAffinity {
    public static final int UNDEFINED_TYPE = -99999;
    private final int sqlType;

    public JdbcColumnKey(String name, int index) {
        super(name, index);
        this.sqlType = -99999;
    }

    public JdbcColumnKey(String name, int index, int sqlType) {
        super(name, index);
        this.sqlType = sqlType;
    }

    public JdbcColumnKey(String name, int index, int sqlType, JdbcColumnKey parent) {
        super(name, index, (FieldKey)parent);
        this.sqlType = sqlType;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public String toString() {
        return "ColumnKey [columnName=" + this.name + ", columnIndex=" + this.index + ", sqlType=" + this.sqlType + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JdbcColumnKey that = (JdbcColumnKey)((Object)o);
        return this.sqlType == that.sqlType;
    }

    public Type getType(Type targetType) {
        return JdbcTypeHelper.toJavaType(this.sqlType, targetType);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.sqlType;
        return result;
    }

    public JdbcColumnKey alias(String alias) {
        return new JdbcColumnKey(alias, this.index, this.sqlType, this);
    }

    public static JdbcColumnKey of(ResultSetMetaData metaData, int columnIndex) throws SQLException {
        return new JdbcColumnKey(metaData.getColumnLabel(columnIndex), columnIndex, metaData.getColumnType(columnIndex));
    }

    public static MapperKey<JdbcColumnKey> mapperKey(ResultSetMetaData metaData) throws SQLException {
        FieldKey[] keys = new JdbcColumnKey[metaData.getColumnCount()];
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            keys[i - 1] = JdbcColumnKey.of(metaData, i);
        }
        return new MapperKey(keys);
    }

    public Class<?>[] getAffinities() {
        switch (this.sqlType) {
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                return new Class[]{String.class};
            }
            case -5: {
                return new Class[]{Long.class, Integer.class, Number.class};
            }
            case 4: 
            case 5: {
                return new Class[]{Integer.class, Long.class, Number.class};
            }
            case 3: 
            case 8: {
                return new Class[]{Double.class, Float.class, Number.class};
            }
            case 6: {
                return new Class[]{Float.class, Double.class, Number.class};
            }
            case 2: {
                return new Class[]{Double.class, Long.class, Number.class};
            }
            case 16: {
                return new Class[]{Boolean.class, Integer.class, Long.class, Number.class};
            }
            case 91: 
            case 92: 
            case 93: {
                return new Class[]{Date.class, Long.class};
            }
        }
        return null;
    }

    public String getOrginalName() {
        return this.parent != null ? ((JdbcColumnKey)this.parent).getOrginalName() : this.getName();
    }
}

