/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.simpleflatmapper.jdbc.QueryBinder;
import org.simpleflatmapper.jdbc.QueryPreparer;
import org.simpleflatmapper.jdbc.impl.MapperQueryBinder;
import org.simpleflatmapper.jdbc.named.NamedSqlQuery;
import org.simpleflatmapper.map.Mapper;

public class MapperQueryPreparer<T>
implements QueryPreparer<T> {
    private final NamedSqlQuery query;
    private final Mapper<T, PreparedStatement> mapper;
    private final String[] generatedKeys;

    public MapperQueryPreparer(NamedSqlQuery query, Mapper<T, PreparedStatement> mapper, String[] generatedKeys) {
        this.query = query;
        this.mapper = mapper;
        this.generatedKeys = generatedKeys;
    }

    @Override
    public QueryBinder<T> prepare(Connection connection) throws SQLException {
        return new MapperQueryBinder(this, connection);
    }

    @Override
    public PreparedStatement prepareStatement(Connection connection) throws SQLException {
        return this.generatedKeys != null ? connection.prepareStatement(this.query.toSqlQuery(), this.generatedKeys) : connection.prepareStatement(this.query.toSqlQuery());
    }

    @Override
    public Mapper<T, PreparedStatement> mapper() {
        return this.mapper;
    }

    @Override
    public String toRewrittenSqlQuery(T value) {
        return this.query.toSqlQuery();
    }
}

