/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.property;

import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import org.simpleflatmapper.jdbc.impl.setter.PreparedStatementSetterImpl;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.map.property.SetterFactoryProperty;
import org.simpleflatmapper.reflect.IndexedSetter;
import org.simpleflatmapper.reflect.IndexedSetterFactory;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.SetterFactory;
import org.simpleflatmapper.util.TypeHelper;

public class IndexedSetterFactoryProperty
extends SetterFactoryProperty {
    private final IndexedSetterFactory<?, ?> setterFactory;

    public IndexedSetterFactoryProperty(IndexedSetterFactory<PreparedStatement, ?> setterFactory) {
        this(setterFactory, IndexedSetterFactoryProperty.getTargetType(setterFactory));
    }

    public IndexedSetterFactoryProperty(IndexedSetterFactory<PreparedStatement, ?> setterFactory, Type targetType) {
        super(IndexedSetterFactoryProperty.getSetterFactory(setterFactory), targetType);
        this.setterFactory = setterFactory;
    }

    private static <A> SetterFactory<PreparedStatement, A> getSetterFactory(final IndexedSetterFactory<PreparedStatement, A> setterFactory) {
        return new SetterFactory<PreparedStatement, A>(){

            public <P> Setter<PreparedStatement, P> getSetter(A arg) {
                IndexedSetter setter = setterFactory.getIndexedSetter(arg);
                if (setter != null) {
                    return new PreparedStatementSetterImpl(((PropertyMapping)arg).getColumnKey().getIndex(), setter);
                }
                return null;
            }
        };
    }

    public IndexedSetterFactory<?, ?> getIndexedSetterFactory() {
        return this.setterFactory;
    }

    public String toString() {
        return "IndexedSetterFactory{IndexedSetterFactory}";
    }

    private static Type getTargetType(IndexedSetterFactory<?, ?> setterFactory) {
        Type[] types = TypeHelper.getGenericParameterForClass(setterFactory.getClass(), IndexedSetterFactory.class);
        return types != null ? types[0] : null;
    }
}

