/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.converter;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.List;
import org.simpleflatmapper.converter.AbstractConverterFactory;
import org.simpleflatmapper.converter.AbstractConverterFactoryProducer;
import org.simpleflatmapper.converter.Converter;
import org.simpleflatmapper.converter.ConverterFactory;
import org.simpleflatmapper.converter.ConvertingScore;
import org.simpleflatmapper.converter.ConvertingTypes;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.ResultSetGetterFactory;
import org.simpleflatmapper.jdbc.converter.CalendarToTimestampConverter;
import org.simpleflatmapper.jdbc.converter.SqlArrayToJavaArrayConverter;
import org.simpleflatmapper.jdbc.converter.SqlArrayToListConverter;
import org.simpleflatmapper.jdbc.converter.UtilDateToDateConverter;
import org.simpleflatmapper.jdbc.converter.UtilDateToTimeConverter;
import org.simpleflatmapper.jdbc.converter.UtilDateToTimestampConverter;
import org.simpleflatmapper.jdbc.converter.time.DateToLocalDateConverter;
import org.simpleflatmapper.jdbc.converter.time.TimeToLocalTimeConverter;
import org.simpleflatmapper.jdbc.converter.time.TimeToOffsetTimeConverter;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.Supplier;
import org.simpleflatmapper.util.SupplierHelper;
import org.simpleflatmapper.util.TypeHelper;

public class JdbcConverterFactoryProducer
extends AbstractConverterFactoryProducer {
    public void produce(Consumer<ConverterFactory> consumer) {
        this.constantConverter(consumer, Time.class, LocalTime.class, new TimeToLocalTimeConverter());
        this.constantConverter(consumer, Date.class, LocalDate.class, new DateToLocalDateConverter());
        this.factoryConverter(consumer, (ConverterFactory)new AbstractConverterFactory<Time, OffsetTime>(Time.class, OffsetTime.class){

            public Converter<Time, OffsetTime> newConverter(ConvertingTypes targetedTypes, Object ... params) {
                ZoneOffset zoneOffset = this.getZoneOffset(params);
                return new TimeToOffsetTimeConverter(zoneOffset);
            }

            private ZoneOffset getZoneOffset(Object[] params) {
                for (Object prop : params) {
                    if (prop instanceof ZoneOffset) {
                        return (ZoneOffset)prop;
                    }
                    if (!SupplierHelper.isSupplierOf((Object)prop, ZoneOffset.class)) continue;
                    return (ZoneOffset)((Supplier)prop).get();
                }
                return ZoneOffset.UTC;
            }
        });
        this.factoryConverter(consumer, (ConverterFactory)new AbstractConverterFactory<java.sql.Array, Object>(java.sql.Array.class, Array.class){

            public Converter<? super java.sql.Array, ? extends Object> newConverter(ConvertingTypes targetedTypes, Object ... params) {
                Type elementType = TypeHelper.getComponentTypeOfListOrArray((Type)targetedTypes.getTo());
                Getter getter = ResultSetGetterFactory.INSTANCE.newGetter(elementType, new JdbcColumnKey("elt", 2), params);
                return new SqlArrayToJavaArrayConverter(TypeHelper.toClass((Type)elementType), getter);
            }

            public ConvertingScore score(ConvertingTypes targetedTypes) {
                return new ConvertingScore(super.score(targetedTypes).getFromScore(), TypeHelper.isArray((Type)targetedTypes.getTo()) ? 1 : -1);
            }
        });
        this.factoryConverter(consumer, (ConverterFactory)new AbstractConverterFactory<java.sql.Array, List>(java.sql.Array.class, List.class){

            public Converter<? super java.sql.Array, ? extends List> newConverter(ConvertingTypes targetedTypes, Object ... params) {
                Type elementType = TypeHelper.getComponentTypeOfListOrArray((Type)targetedTypes.getTo());
                Getter getter = ResultSetGetterFactory.INSTANCE.newGetter(elementType, new JdbcColumnKey("elt", 2), params);
                return new SqlArrayToListConverter(getter);
            }
        });
        this.constantConverter(consumer, Calendar.class, Timestamp.class, new CalendarToTimestampConverter());
        this.constantConverter(consumer, java.util.Date.class, Timestamp.class, new UtilDateToTimestampConverter());
        this.constantConverter(consumer, java.util.Date.class, Time.class, new UtilDateToTimeConverter());
        this.constantConverter(consumer, java.util.Date.class, Date.class, new UtilDateToDateConverter());
    }
}

