/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.datastax.impl.getter;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableByIndexData;
import com.datastax.driver.core.TupleType;
import java.lang.reflect.Type;
import java.util.List;
import org.simpleflatmapper.datastax.DatastaxColumnKey;
import org.simpleflatmapper.datastax.DatastaxMapperFactory;
import org.simpleflatmapper.datastax.impl.getter.DatastaxUDTGetter;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.SourceMapper;
import org.simpleflatmapper.map.mapper.ConstantSourceMapperBuilder;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.tuple.Tuple2;

public class DatastaxTupleGetter<T extends Tuple2<?, ?>>
implements Getter<GettableByIndexData, T> {
    private final SourceMapper<GettableByIndexData, T> mapper;
    private final int index;

    public DatastaxTupleGetter(SourceMapper<GettableByIndexData, T> mapper, int index) {
        this.mapper = mapper;
        this.index = index;
    }

    public T get(GettableByIndexData target) throws Exception {
        return (T)((Tuple2)this.mapper.map((Object)target.getTupleValue(this.index)));
    }

    public static <P extends Tuple2<?, ?>> Getter<GettableByIndexData, P> newInstance(DatastaxMapperFactory factory, Type target, TupleType tt, int index) {
        SourceMapper<GettableByIndexData, P> mapper = DatastaxTupleGetter.newTupleMapper(target, tt, factory);
        return new DatastaxTupleGetter<P>(mapper, index);
    }

    public static <P extends Tuple2<?, ?>> SourceMapper<GettableByIndexData, P> newTupleMapper(Type target, TupleType tt, DatastaxMapperFactory factory) {
        ConstantSourceMapperBuilder builder = DatastaxUDTGetter.newFieldMapperBuilder(factory, target);
        List componentTypes = tt.getComponentTypes();
        for (int i = 0; i < componentTypes.size(); ++i) {
            FieldMapperColumnDefinition identity = FieldMapperColumnDefinition.identity();
            builder.addMapping((FieldKey)new DatastaxColumnKey("elt" + i, i, (DataType)componentTypes.get(i)), identity);
        }
        return builder.mapper();
    }
}

