/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.datastax;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableByIndexData;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.exceptions.DriverException;
import org.simpleflatmapper.datastax.DatastaxColumnKey;
import org.simpleflatmapper.datastax.DatastaxMapper;
import org.simpleflatmapper.datastax.impl.ResultSetEnumarable;
import org.simpleflatmapper.map.ConsumerErrorHandler;
import org.simpleflatmapper.map.Mapper;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.context.MappingContextFactory;
import org.simpleflatmapper.map.context.MappingContextFactoryBuilder;
import org.simpleflatmapper.map.mapper.AbstractMapperBuilder;
import org.simpleflatmapper.map.mapper.JoinMapper;
import org.simpleflatmapper.map.mapper.KeyFactory;
import org.simpleflatmapper.map.mapper.MapperSource;
import org.simpleflatmapper.map.mapper.MapperSourceImpl;
import org.simpleflatmapper.map.mapper.StaticSetRowMapper;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.reflect.getter.GetterFactory;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.util.Enumarable;
import org.simpleflatmapper.util.UnaryFactory;

public final class DatastaxMapperBuilder<T>
extends AbstractMapperBuilder<Row, T, DatastaxColumnKey, DatastaxMapper<T>, DatastaxMapperBuilder<T>> {
    public static final KeyFactory<DatastaxColumnKey> KEY_FACTORY = new KeyFactory<DatastaxColumnKey>(){

        public DatastaxColumnKey newKey(String name, int i) {
            return new DatastaxColumnKey(name, i);
        }
    };

    public DatastaxMapperBuilder(ClassMeta<T> classMeta, MapperConfig<DatastaxColumnKey, FieldMapperColumnDefinition<DatastaxColumnKey>> mapperConfig, GetterFactory<GettableByIndexData, DatastaxColumnKey> getterFactory, MappingContextFactoryBuilder<GettableByIndexData, DatastaxColumnKey> parentBuilder) {
        super(classMeta, parentBuilder, mapperConfig, (MapperSource)new MapperSourceImpl(GettableByIndexData.class, getterFactory), KEY_FACTORY, 0);
    }

    public DatastaxMapperBuilder<T> addMapping(String column, int index, DataType dataType, Object ... properties) {
        return (DatastaxMapperBuilder)this.addMapping(new DatastaxColumnKey(column, index, dataType), properties);
    }

    public DatastaxMapperBuilder<T> addMapping(ColumnDefinitions metaData) {
        for (int i = 1; i <= metaData.size(); ++i) {
            this.addMapping(metaData.getName(i), i, metaData.getType(i), new Object[0]);
        }
        return this;
    }

    protected DatastaxMapper<T> newJoinJdbcMapper(Mapper<Row, T> mapper) {
        return new JoinDatastaxMapper<T>(mapper, this.mapperConfig.consumerErrorHandler(), (MappingContextFactory<? super Row>)this.mappingContextFactoryBuilder.newFactory());
    }

    protected DatastaxMapper<T> newStaticJdbcMapper(Mapper<Row, T> mapper) {
        return new StaticDatastaxMapper<T>(mapper, this.mapperConfig.consumerErrorHandler(), (MappingContextFactory<? super Row>)this.mappingContextFactoryBuilder.newFactory());
    }

    public static class StaticDatastaxMapper<T>
    extends StaticSetRowMapper<Row, ResultSet, T, DriverException>
    implements DatastaxMapper<T> {
        public StaticDatastaxMapper(Mapper<Row, T> mapper, ConsumerErrorHandler errorHandler, MappingContextFactory<? super Row> mappingContextFactory) {
            super(mapper, errorHandler, mappingContextFactory, (UnaryFactory)new ResultSetEnumarableFactory());
        }
    }

    private static class ResultSetEnumarableFactory
    implements UnaryFactory<ResultSet, Enumarable<Row>> {
        private ResultSetEnumarableFactory() {
        }

        public Enumarable<Row> newInstance(ResultSet rows) {
            return new ResultSetEnumarable(rows);
        }
    }

    private static class JoinDatastaxMapper<T>
    extends JoinMapper<Row, ResultSet, T, DriverException>
    implements DatastaxMapper<T> {
        public JoinDatastaxMapper(Mapper<Row, T> mapper, ConsumerErrorHandler errorHandler, MappingContextFactory<? super Row> mappingContextFactory) {
            super(mapper, errorHandler, mappingContextFactory, (UnaryFactory)new ResultSetEnumarableFactory());
        }
    }
}

