/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.datastax.impl.getter;

import com.datastax.driver.core.GettableByIndexData;
import java.util.HashMap;
import java.util.Map;
import org.simpleflatmapper.converter.Converter;
import org.simpleflatmapper.reflect.Getter;

public class DatastaxMapWithConverterGetter<K, V, KO, VO>
implements Getter<GettableByIndexData, Map<KO, VO>> {
    private final int index;
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final Converter<K, KO> keyConverter;
    private final Converter<V, VO> valueConverter;

    public DatastaxMapWithConverterGetter(int index, Class<K> keyType, Class<V> valueType, Converter<K, KO> keyConverter, Converter<V, VO> valueConverter) {
        this.index = index;
        this.keyType = keyType;
        this.valueType = valueType;
        this.keyConverter = keyConverter;
        this.valueConverter = valueConverter;
    }

    public Map<KO, VO> get(GettableByIndexData target) throws Exception {
        Map map = target.getMap(this.index, this.keyType, this.valueType);
        HashMap<Object, Object> outMap = new HashMap<Object, Object>();
        for (Map.Entry e : map.entrySet()) {
            outMap.put(this.keyConverter.convert(e.getKey()), this.valueConverter.convert(e.getValue()));
        }
        return outMap;
    }
}

